/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.event;

import ch.e2e.builder.regtest.event.LibraryChangedEvent;
import ch.e2e.builder.regtest.event.LibraryChangedListener;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public enum LibraryObserver implements LibraryChangedListener
{
    INSTANCE;

    private Map<String, EventListenerList> libraryListeners = new HashMap<String, EventListenerList>();

    public static LibraryObserver getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.libraryListeners.clear();
    }

    public void registerForLibrary(LibraryChangedListener listener, TreeTestSuite library) {
        String key = library.getId();
        EventListenerList listeners = this.libraryListeners.get(key);
        if (listeners == null) {
            listeners = new EventListenerList();
            this.libraryListeners.put(key, listeners);
        }
        listeners.add(LibraryChangedListener.class, listener);
    }

    public void unregisterForLibrary(LibraryChangedListener listener, TreeTestSuite library) {
        String key = library.getId();
        EventListenerList listeners = this.libraryListeners.get(key);
        if (listeners != null) {
            listeners.remove(LibraryChangedListener.class, listener);
        }
    }

    @Override
    public void libraryChanged(LibraryChangedEvent event) {
        EventListenerList listeners = this.libraryListeners.get(event.getLibrary().getId());
        if (listeners != null) {
            for (LibraryChangedListener l : (LibraryChangedListener[])listeners.getListeners(LibraryChangedListener.class)) {
                l.libraryChanged(event.copy());
            }
        }
    }

    @Override
    public void testRemoved(LibraryChangedEvent event) {
        EventListenerList listeners = this.libraryListeners.get(event.getLibrary().getId());
        if (listeners != null) {
            for (LibraryChangedListener l : (LibraryChangedListener[])listeners.getListeners(LibraryChangedListener.class)) {
                l.testRemoved(event.copy());
            }
        }
    }

    @Override
    public void nameChanged(LibraryChangedEvent event) {
        EventListenerList listeners;
        EventListenerList eventListenerList = listeners = event.getOldId() == null ? this.libraryListeners.get(event.getLibrary().getId()) : this.libraryListeners.remove(event.getOldId());
        if (listeners != null) {
            if (event.getOldId() != null) {
                this.libraryListeners.put(event.getLibrary().getId(), listeners);
            }
            for (LibraryChangedListener l : (LibraryChangedListener[])listeners.getListeners(LibraryChangedListener.class)) {
                l.nameChanged(event.copy());
            }
        }
    }
}

