/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.junit;

import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestcase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestUnit
extends TestSuite {
    private List<E2ETestSuite> testSuites;
    private List<Test> failures = new ArrayList<Test>();
    private List<Test> errors = new ArrayList<Test>();
    private List<Test> runTests = new ArrayList<Test>();
    private TestResult result;
    private Test test;

    public TestUnit() {
        this.testSuites = new ArrayList<E2ETestSuite>();
    }

    public void run(TestResult result) {
        this.result = result;
        super.run(result);
    }

    public List<E2ETestSuite> getTestSuites() {
        return this.testSuites;
    }

    public void addTestSuite(E2ETestSuite testSuite) {
        this.testSuites.add(testSuite);
        super.addTest((Test)testSuite);
    }

    public int size() {
        return this.testSuites.size();
    }

    public E2ETestSuite get(int index) {
        return this.testSuites.get(index);
    }

    public int indexOf(E2ETestSuite test) {
        return this.testSuites.indexOf(test);
    }

    public void addFailure(Test t) {
        this.failures.add(t);
    }

    public void addError(Test t) {
        this.errors.add(t);
    }

    public void addRunTest(Test t) {
        this.runTests.add(t);
    }

    public boolean wasRun(Test t) {
        boolean result = t instanceof E2ETestcase ? this.runTests.contains(((E2ETestcase)t).getTest()) : this.runTests.contains(t);
        return result;
    }

    public boolean isError(Test t) {
        boolean result = t instanceof E2ETestcase ? this.errors.contains(((E2ETestcase)t).getTest()) : this.errors.contains(t);
        return result;
    }

    public boolean isFailure(Test t) {
        boolean result = t instanceof E2ETestcase ? this.failures.contains(((E2ETestcase)t).getTest()) : this.failures.contains(t);
        return result;
    }

    public void resetResults() {
        this.failures.clear();
        this.runTests.clear();
        this.errors.clear();
    }

    public void runTest(Test test, TestResult result) {
        this.test = test;
        super.runTest(test, result);
    }

    public void cancel() {
        if (this.test != null && this.test instanceof E2ETestcase) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ((E2ETestcase)TestUnit.this.test).cancel();
                }
            }).start();
        }
        this.result.stop();
    }

    protected List<Test> getFailures() {
        return this.failures;
    }

    protected List<Test> getErrors() {
        return this.errors;
    }

    protected List<Test> getRunTests() {
        return this.runTests;
    }
}

