/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.net;

import ch.e2e.dom.DomUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class NetworkTools {
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCALDOMAIN_NAME = "localdomain";
    public static final String LOCALHOST_IP = "127.0.0.1";
    private static final int SO_LINGER = 500;
    private static final int SO_TIMEOUT = 500;

    public static boolean ping(String host, int port) {
        return NetworkTools.ping(host, port, null);
    }

    public static boolean ping(String host, int port, byte[] data) {
        boolean result = false;
        try {
            Socket socket = new Socket();
            socket.setSoTimeout(500);
            socket.setSoLinger(true, 500);
            socket.connect(new InetSocketAddress(host, port), 500);
            if (data != null) {
                socket.getOutputStream().write(data);
            }
            socket.close();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalhost() {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return LOCALHOST_NAME;
        }
        String hostname = localhost.getHostName();
        if (hostname != null && hostname.indexOf(".") == -1) {
            hostname = localhost.getCanonicalHostName();
        }
        if (hostname != null) {
            hostname = hostname.toLowerCase();
        }
        return hostname;
    }

    public static boolean isFullQualifiedDomainName(String host) {
        return host != null && host.indexOf(".") > 0;
    }

    public static String makeFullQualifiedDomainName(String host) {
        String domain;
        String result = host;
        if (!NetworkTools.isFullQualifiedDomainName(host) && NetworkTools.isFullQualifiedDomainName(domain = NetworkTools.getLocalhost())) {
            result = host + domain.substring(domain.indexOf("."));
        }
        return result;
    }

    public static Document httpRequest(String spec, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), null, requestProperties, null);
    }

    public static Document httpRequest(String spec, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), null, requestProperties, data);
    }

    public static Document httpRequest(String spec) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), null, null, null);
    }

    public static Document httpRequest(String spec, RequestMethod method) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), method, null, null);
    }

    public static Document httpRequest(String spec, RequestMethod method, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), method, requestProperties, null);
    }

    public static Document httpRequest(String spec, RequestMethod method, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL(spec), method, requestProperties, data);
    }

    public static Document httpRequest(String host, String file, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), null, requestProperties, null);
    }

    public static Document httpRequest(String host, String file, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), null, requestProperties, data);
    }

    public static Document httpRequest(String host, int port, String file, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), null, requestProperties, null);
    }

    public static Document httpRequest(String host, int port, String file, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), null, requestProperties, data);
    }

    public static Document httpRequest(String host, int port, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, "/"), null, requestProperties, data);
    }

    public static Document httpRequest(String host, String file) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), null, null, null);
    }

    public static Document httpRequest(String host, String file, RequestMethod method) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), method, null, null);
    }

    public static Document httpRequest(String host, String file, RequestMethod method, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), method, requestProperties, null);
    }

    public static Document httpRequest(String host, String file, RequestMethod method, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, file), method, requestProperties, data);
    }

    public static Document httpRequest(String host, int port, String file) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), null, null, null);
    }

    public static Document httpRequest(String host, int port, String file, RequestMethod method) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), method, null, null);
    }

    public static Document httpRequest(String host, int port, String file, RequestMethod method, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), method, requestProperties, null);
    }

    public static Document httpRequest(String host, int port, String file, RequestMethod method, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, file), method, requestProperties, data);
    }

    public static Document httpRequest(String host, int port, RequestMethod method) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, "/"), method, null, null);
    }

    public static Document httpRequest(String host, int port, RequestMethod method, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, "/"), method, requestProperties, null);
    }

    public static Document httpRequest(String host, int port, RequestMethod method, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(new URL("http", host, port, "/"), method, requestProperties, data);
    }

    public static Document httpRequest(URL url) throws IOException {
        return NetworkTools.httpRequest(url, null, null, null);
    }

    public static Document httpRequest(URL url, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(url, null, requestProperties, null);
    }

    public static Document httpRequest(URL url, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(url, null, requestProperties, data);
    }

    public static Document httpRequest(URL url, RequestMethod method) throws IOException {
        return NetworkTools.httpRequest(url, method, null, null);
    }

    public static Document httpRequest(URL url, RequestMethod method, Map<String, String> requestProperties) throws IOException {
        return NetworkTools.httpRequest(url, method, requestProperties, null);
    }

    public static Document httpRequest(URL url, RequestMethod method, Map<String, String> requestProperties, byte[] data) throws IOException {
        return NetworkTools.httpRequest(url, method, requestProperties, data, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document httpRequest(URL url, RequestMethod method, Map<String, String> requestProperties, byte[] data, int readTimeout) throws IOException {
        if (!url.getProtocol().startsWith("http")) {
            throw new MalformedURLException("Protocol has to be HTTP");
        }
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        Document response = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(false);
            if (readTimeout > 0) {
                connection.setReadTimeout(readTimeout);
            }
            if (method != null) {
                connection.setRequestMethod(method.name());
            }
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (data != null) {
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Length", String.valueOf(data.length));
                outputStream = connection.getOutputStream();
                outputStream.write(data);
            }
            inputStream = connection.getInputStream();
            try {
                response = DomUtilities.parse(inputStream, false, false, true);
            }
            catch (Exception e) {
                response = DomUtilities.newDocument("RequestError");
                Element element = response.createElement(e.getClass().getName());
                element.setTextContent(e.getMessage());
                response.getDocumentElement().appendChild(element);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

