/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.io.StreamRedirector;
import java.io.PrintStream;

public abstract class SystemStreamRedirector
extends StreamRedirector {
    private PrintStream originalStream = this.getOriginalStream();
    private boolean enabled = false;
    private boolean originalStreamEnabled = false;

    protected SystemStreamRedirector(PrintStream stream) {
        super(stream);
    }

    public void setOriginalStreamEnabled(boolean originalStreamEnabled) {
        this.originalStreamEnabled = originalStreamEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled ^ enabled) {
            this.originalStream.flush();
            this.enabled = enabled;
            if (enabled) {
                this.redirect();
            } else {
                this.reset(this.originalStream);
            }
        }
    }

    protected abstract PrintStream getOriginalStream();

    protected abstract void redirect();

    protected abstract void reset(PrintStream var1);

    @Override
    protected void printOut(String outString) {
        super.printOut(outString);
        if (this.originalStreamEnabled) {
            this.originalStream.print(outString);
            this.originalStream.flush();
        }
    }
}

