/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.event;

import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.event.Logging;
import ch.e2e.event.RuntimeTargetException;
import java.util.ArrayList;
import java.util.EventObject;

public class EventExecuterList
implements EventExecuter,
Logging {
    private ArrayList executerList;
    private ArrayList defaultExecuter;

    @Override
    public void execute(EventObject event) throws EventExecutionVetoException {
        if (this.executerList != null || this.defaultExecuter != null) {
            ArrayList executer = null;
            if (this.executerList != null) {
                executer = new ArrayList(this.executerList);
            }
            if (this.defaultExecuter != null) {
                if (executer == null) {
                    executer = new ArrayList(this.defaultExecuter);
                } else {
                    executer.addAll(this.defaultExecuter);
                }
                this.defaultExecuter.clear();
                this.defaultExecuter = null;
            }
            int length = executer.size();
            for (int i = 0; i < length; ++i) {
                ((EventExecuter)executer.get(i)).execute(event);
            }
        }
    }

    int size() {
        return this.executerList == null ? 0 : this.executerList.size();
    }

    void removeExecuter(EventExecuter executer) throws RuntimeException {
        if (this.executerList == null || !this.executerList.contains(executer)) {
            throw new RuntimeException("The executer " + executer + " is not registered.");
        }
        this.executerList.remove(executer);
        if (this.executerList.size() == 0) {
            this.executerList = null;
        }
    }

    void addExecuter(EventExecuter executer) {
        if (this.executerList != null && this.executerList.contains(executer)) {
            throw new RuntimeException("The executer " + executer + " is allready registered.");
        }
        if (this.executerList == null) {
            this.executerList = new ArrayList();
        }
        if (this.defaultExecuter != null && this.defaultExecuter.contains(executer)) {
            this.defaultExecuter.remove(executer);
        }
        this.executerList.add(executer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addDefaultExecuterInstance(Class eventExecuter) throws ClassCastException, RuntimeTargetException {
        Class<?>[] interfaces = eventExecuter.getInterfaces();
        boolean isEventExecuter = false;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(EventExecuter.class)) continue;
            isEventExecuter = true;
            break;
        }
        if (!isEventExecuter) throw new ClassCastException("The executer " + eventExecuter + " must implement the ch.e2e.event.EventExecuter interface.");
        if (this.contains(eventExecuter.getName())) return;
        if (this.defaultExecuter == null) {
            this.defaultExecuter = new ArrayList();
        }
        try {
            Object executer = eventExecuter.newInstance();
            if (this.executerList != null && this.executerList.contains(executer)) {
                return;
            }
            boolean bl = false;
            boolean registered = bl;
            if (registered) return;
            this.defaultExecuter.add(executer);
            return;
        }
        catch (Exception ex) {
            throw new RuntimeTargetException(ex);
        }
    }

    private boolean contains(String eventExecuterName) {
        if (this.executerList == null) {
            return false;
        }
        int length = this.executerList.size();
        for (int i = 0; i < length; ++i) {
            String className = this.executerList.get(i).getClass().getName();
            if (!eventExecuterName.equals(className)) continue;
            return true;
        }
        return false;
    }

    boolean contains(EventExecuter elem) {
        return this.executerList != null && this.executerList.contains(elem);
    }
}

