/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tree.menu;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.DeleteWsdlEvent;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousFolderEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;
import javax.swing.tree.TreePath;

public class DeleteWsdlExecuter
implements EventExecuter {
    private TraceViewer traceViewer;

    public DeleteWsdlExecuter(TraceViewer traceViewer) {
        this.traceViewer = traceViewer;
    }

    public void execute(EventObject event) {
        TreePath path = ((DeleteWsdlEvent)event).getPath();
        AbstractWSDLFolder wsdlFolder = (AbstractWSDLFolder)path.getLastPathComponent();
        String name = wsdlFolder.getName();
        String question = this.traceViewer.getTranslation("wsdl.delete.question.message");
        question = StringTools.replaceProperty((String)question, (String)"wsdl", (String)name);
        String title = this.traceViewer.getTranslation("wsdl.delete.question.title");
        title = StringTools.replaceProperty((String)title, (String)"wsdl", (String)name);
        String subtitle = this.traceViewer.getTranslation("wsdl.delete.question.subtitle");
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)"wsdl", (String)name)), (String)question)) {
            try {
                wsdlFolder.getParent().delete((TestcaseObject)wsdlFolder);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = this.traceViewer.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                    this.traceViewer.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                }
            }
            EventController.fire((EventObject)new RefreshSynchronousTreeEvent((Object)this));
            TestcaseObject testcaseObject = this.traceViewer.getAsynchronousRoot().get(name);
            if (testcaseObject != null) {
                EventController.fire((EventObject)((Object)new DeleteAsynchronousFolderEvent(event.getSource(), new TreePath(testcaseObject.getPath()))));
            }
        }
    }
}

