/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.event.SelectUmlObjectEvent;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.builder.trace.testcase.TreeObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectWithDiagram;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.trace.tree.RefreshTreeEvent;
import ch.e2e.builder.trace.tree.TreeIcons;
import ch.e2e.builder.traceviewer.swing.MainPanel;
import ch.e2e.builder.traceviewer.swing.tree.TestcaseTreeModel;
import ch.e2e.builder.traceviewer.swing.tree.TestcaseTreeRenderer;
import ch.e2e.builder.traceviewer.swing.tree.TreeModelSearcher;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.RendererPreferences;
import ch.e2e.util.StringTools;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TreeSearchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class TreeView
extends JPanel
implements EventExecuter,
ProjectListener,
TreeSelectionListener,
TreeWillExpandListener {
    private Tree tree;
    private MainPanel mainPanel;
    private E2EBuilderModule module;
    private boolean valueChanged = false;
    private TreePath selectionPath;

    protected TreeView(TestcaseRoot root, MainPanel mainPanel, E2EBuilderModule module) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.module = module;
        this.createGui(root);
        this.addEventHandler();
        EventController.register((EventExecuter)this, SelectUmlObjectEvent.class);
        EventController.register((EventExecuter)this, SelectInTreeEvent.class);
    }

    protected abstract void addEventHandler();

    protected Tree createTree(TestcaseRoot root) {
        TestcaseTreeModel treeModel = this.newTreeModel(root);
        TestcaseTreeRenderer treeRenderer = new TestcaseTreeRenderer(new RendererPreferences((AbstractTreeModel)treeModel));
        Tree tree = new Tree((AbstractTreeModel)treeModel, (TreeCellRenderer)treeRenderer);
        tree.addTreeWillExpandListener((TreeWillExpandListener)this);
        tree.setEditable(true);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setSelectWithPopupTrigger(false);
        tree.getSelectionModel().setSelectionMode(1);
        return tree;
    }

    protected abstract TestcaseTreeModel newTreeModel(TestcaseRoot var1);

    public E2EBuilderModule getModule() {
        return this.module;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public TestcaseTreeModel getModel() {
        return (TestcaseTreeModel)((Object)this.tree.getModel());
    }

    public TreePath getSelectionPath() {
        return this.selectionPath;
    }

    public void setSelectionPath(TreePath path) {
        this.selectionPath = path;
        this.tree.setSelectionPath(path);
        if (path == null) {
            this.clearSelection();
        }
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    public void scrollPathToVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    protected MainPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean select = enabled && !this.tree.isEnabled() && this.selectionPath != null;
        this.tree.setEnabled(enabled);
        if (select) {
            this.setSelectionPath(this.selectionPath);
        }
    }

    public void clearSelection() {
        this.valueChanged = false;
        this.mainPanel.clearSelection();
    }

    public void execute(EventObject event) {
        if (event instanceof SelectUmlObjectEvent) {
            if (!this.valueChanged) {
                this.selectDiagram((SelectUmlObjectEvent)event);
            }
        } else if (event instanceof SelectInTreeEvent) {
            String umlObjectId;
            UmlObject umlObject = ((SelectInTreeEvent)event).getUmlObject();
            if (umlObject == null && (umlObjectId = ((SelectInTreeEvent)event).getUmlObjectId()) != null) {
                umlObject = this.getModel().find(umlObjectId);
            }
            if (umlObject != null) {
                TreePath path = new TreePath(umlObject.getPath());
                this.setSelectionPath(path);
                this.tree.scrollPathToVisible(path);
            }
        }
    }

    public void refreshTree(EventObject event) {
        TestcaseObject parent = ((RefreshTreeEvent)event).getNewSelection();
        if (parent == null) {
            this.setSelectionPath(null);
            List expandedRows = this.getTree().getExpandedRows();
            this.refresh();
            if (expandedRows.size() > 0) {
                this.getTree().expandRows(expandedRows);
            }
        } else {
            List expandedRows = this.getTree().getExpandedRows();
            this.refresh();
            TreePath path = new TreePath(parent.getPath());
            for (Object o : expandedRows) {
                if (path.isDescendant((TreePath)o)) continue;
                this.expandPath((TreePath)o);
            }
            this.expandPath(path);
            this.setSelectionPath(path);
        }
    }

    public void refresh() {
        this.getModel().refresh();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.valueChanged = true;
        this.selectionPath = e.getNewLeadSelectionPath();
        this.mainPanel.pathChanged(this.selectionPath);
        this.valueChanged = false;
    }

    private void createGui(TestcaseRoot root) {
        this.tree = this.createTree(root);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        JScrollPane pane = new JScrollPane((Component)this.tree, 20, 30);
        this.add((Component)pane, "Center");
        this.add((Component)this.createSearchableBar(), "Last");
    }

    private SearchableBar createSearchableBar() {
        TreeSearchable searchable = SearchableUtils.installSearchable((JTree)this.tree);
        searchable.setRecursive(true);
        searchable.setCaseSensitive(false);
        searchable.setFromStart(false);
        searchable.setRepeats(true);
        SearchableBar searchableBar = SearchableBar.install((Searchable)searchable, (KeyStroke)KeyStroke.getKeyStroke(70, 128), (SearchableBar.Installer)new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                searchableBar.setVisible(true);
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                searchableBar.setVisible(false);
            }
        });
        searchableBar.setCompact(true);
        Dimension minSize = searchableBar.getMinimumSize();
        searchableBar.setMinimumSize(new Dimension(5, minSize.height));
        return searchableBar;
    }

    protected void selectDiagram(SelectUmlObjectEvent event) {
        UmlObject umlObject = event.getUmlObject();
        if (umlObject == null) {
            this.selectTestcasePath(event.getTestcase(), new ArrayList<UmlObject>());
        } else {
            while (umlObject != null && !(umlObject instanceof UmlObjectWithDiagram)) {
                umlObject = umlObject.getParent();
            }
            if (umlObject != null) {
                this.selectUmlObject(umlObject, event.getTestcase());
            }
        }
    }

    private void selectUmlObject(UmlObject umlObject, Testcase testcase) {
        ArrayList<UmlObject> umlPath = new ArrayList<UmlObject>();
        UmlObject umlParent = umlObject;
        while (!(umlParent instanceof UmlTree)) {
            umlPath.add(0, umlParent);
            umlParent = umlParent.getParent();
        }
        this.selectTestcasePath(testcase, umlPath);
    }

    private void selectTestcasePath(Testcase testcase, List<UmlObject> umlPath) {
        ArrayList<Object> testcasePath = new ArrayList<Object>();
        for (Testcase testcaseParent = testcase; testcaseParent != null; testcaseParent = testcaseParent.getParent()) {
            testcasePath.add(0, testcaseParent);
        }
        testcasePath.addAll(umlPath);
        TreePath path = new TreePath(testcasePath.toArray());
        this.scrollPathToVisible(path);
        this.setSelectionPath(path);
        this.repaint();
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
        this.setSelectionPath(null);
    }

    public void projectOpened(ProjectEvent event) {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Testcase testcase;
        TreePath path = event.getPath();
        Object node = path.getLastPathComponent();
        if (node instanceof Testcase && (testcase = (Testcase)node).getUmlTree() == null) {
            int index = testcase.getChildCount();
            EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new LoadUmlTreeTransaction(this.getModel(), path, index), (Object)testcase));
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    private class SearchPanel
    extends JToolBar {
        private static final int COLUMNS = 15;
        private TreeModelSearcher searcher;
        private JTextField searchField;
        private JButton upButton;
        private JButton downButton;
        private JLabel countField;
        private int matchIndex = -1;

        public SearchPanel() {
            this.searcher = new TreeModelSearcher((AbstractTreeModel)TreeView.this.tree.getModel());
            this.createGui();
        }

        private void createGui() {
            this.setMinimumSize(new Dimension(0, 0));
            this.setRollover(true);
            this.setFloatable(false);
            this.createSearchField();
            this.createUpButton();
            this.createDownButton();
            this.createCaseSensitiveBox();
            this.createCountField();
        }

        private void createSearchField() {
            String name = TreeView.this.module.getTranslation("tree.search.find", "Find:");
            if (name == null || name.length() == 0) {
                this.add(new JLabel(TreeIcons.searchIcon));
            } else {
                this.add(new JLabel(name));
            }
            this.searchField = new JTextField(15);
            this.searchField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SearchPanel.this.update(SearchPanel.this.searcher.search(SearchPanel.this.searchField.getText()));
                }
            });
            this.add(this.searchField);
        }

        private void createUpButton() {
            this.upButton = new JButton(new UpAction());
            this.upButton.setIcon(TreeIcons.upIcon);
            this.upButton.setEnabled(false);
            this.upButton.setFocusable(false);
            this.add(this.upButton);
        }

        private void createDownButton() {
            this.downButton = new JButton(new DownAction());
            this.downButton.setIcon(TreeIcons.downIcon);
            this.downButton.setEnabled(false);
            this.downButton.setFocusable(false);
            this.add(this.downButton);
        }

        private void createCaseSensitiveBox() {
            JCheckBox checkBox = new JCheckBox(TreeView.this.module.getTranslation("tree.search.case.sensitive", "case sensitive"));
            checkBox.setFocusable(false);
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SearchPanel.this.searcher.setCaseSensitive(e.getStateChange() == 1);
                    SearchPanel.this.update(SearchPanel.this.searcher.getMatches());
                }
            });
            this.add(checkBox);
        }

        private void createCountField() {
            String name = TreeView.this.module.getTranslation("tree.search.match.count", "Match count:");
            if (name != null && name.length() > 0) {
                this.add(new JLabel(name));
                this.countField = new JLabel("0");
                this.add(this.countField);
            }
        }

        private void update(List<Object> matches) {
            int matchCount = matches.size();
            this.upButton.setEnabled(matchCount > 1);
            this.downButton.setEnabled(matchCount > 1);
            if (this.countField != null) {
                this.countField.setText(String.valueOf(matchCount));
            }
            if (matchCount > 0) {
                this.searchField.setForeground(Color.BLACK);
                this.matchIndex = 0;
                this.selectMatch();
            } else {
                this.searchField.setForeground(Color.RED);
            }
        }

        private void selectMatch() {
            List<Object> matches = this.searcher.getMatches();
            if (this.matchIndex > -1 && !matches.isEmpty()) {
                TreePath path = new TreePath(((TreeObject)matches.get(this.matchIndex)).getPath());
                TreeView.this.tree.setSelectionPath(path);
                TreeView.this.tree.scrollPathToVisible(path);
            }
        }

        public class DownAction
        extends AbstractAction {
            public DownAction() {
                super(TreeView.this.module.getTranslation("tree.search.down", "Down"), TreeIcons.downIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchPanel.this.searchField.getText().isEmpty()) {
                    SearchPanel.this.matchIndex++;
                    if (SearchPanel.this.matchIndex > SearchPanel.this.searcher.getMatchCount() - 1) {
                        SearchPanel.this.matchIndex = 0;
                    }
                    SearchPanel.this.selectMatch();
                }
            }
        }

        public class UpAction
        extends AbstractAction {
            public UpAction() {
                super(TreeView.this.module.getTranslation("tree.search.up", "Up"), TreeIcons.upIcon);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchPanel.this.searchField.getText().isEmpty()) {
                    SearchPanel.this.matchIndex--;
                    if (SearchPanel.this.matchIndex < 0) {
                        SearchPanel.this.matchIndex = SearchPanel.this.searcher.getMatchCount() - 1;
                    }
                    SearchPanel.this.selectMatch();
                }
            }
        }
    }

    private class LoadUmlTreeTransaction
    extends E2EBuilderTransaction {
        private final TestcaseTreeModel model;
        private final TreePath path;
        private final int index;

        public LoadUmlTreeTransaction(TestcaseTreeModel model, TreePath path, int index) {
            this.model = model;
            this.path = path;
            this.index = index;
        }

        public Object doTransaction(Object transactionData) throws Throwable {
            Testcase testcase = (Testcase)transactionData;
            testcase.loadUmlTreeFromDisk();
            return testcase.getUmlTree();
        }

        public void prepareTransaction() {
        }

        public void setTransactionResult(Object transactionResult) {
            if (transactionResult instanceof UmlTree) {
                UmlTree umlTree = (UmlTree)transactionResult;
                int childCount = umlTree.getChildCount();
                if (childCount > 0) {
                    int[] childIndices = new int[childCount];
                    Object[] children = new Object[childCount];
                    for (int i = 0; i < childCount; ++i) {
                        childIndices[i] = this.index + i;
                        children[i] = umlTree.getChild(i);
                    }
                    this.model.nodesInserted(this.path, childIndices, children);
                } else {
                    TreeObject[] path = umlTree.getOwner().getPath();
                    String msg = StringTools.join(Arrays.asList(Arrays.copyOfRange(path, 1, path.length)), (String)"/") + ":  UmlTree is empty";
                    EventController.fire((EventObject)new SendWarningEvent((Object)this, msg, null, TreeView.this.module.getName(), TreeView.this.module.getDefaultMessageViewTitle()));
                }
            }
        }

        public String getDescription() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

