/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.Message;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class MessagePopupMenu
extends JPopupMenu {
    private Message message;

    public MessagePopupMenu() {
        this(true);
    }

    public MessagePopupMenu(boolean addCopyItem) {
        this.addItems();
        if (addCopyItem) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            this.addCopyItem();
        }
    }

    protected abstract void addItems();

    private void addCopyItem() {
        JMenuItem copy = new JMenuItem("Copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(MessagePopupMenu.this.message.getMessage()), null);
            }
        });
        this.add(copy);
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }
}

