/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import ch.e2e.print.Page;
import java.awt.Toolkit;
import java.awt.print.Paper;

public class PrintTools {
    private static Page a5;
    private static Page a4;
    private static Page a3;
    private static Page letter;
    private static Page[] pageFormats;

    public static double getDots(double screenPixel) {
        int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        double result = (int)(screenPixel * (double)resolution / 72.0);
        return result;
    }

    public static double milimeter2Dots(double milimeter) {
        return milimeter / 25.4 * 72.0;
    }

    public static double dots2Milimeter(double dots) {
        return dots * 25.4 / 72.0;
    }

    public static double inches2Dots(double inches) {
        return inches * 72.0;
    }

    public static double dots2Inches(double dots) {
        return dots / 72.0;
    }

    public static double inches2Milimeter(double inches) {
        return inches * 25.4;
    }

    public static double milimeter2Inches(double milimeter) {
        return milimeter / 25.4;
    }

    public static Page[] getDefaultPageFormats() {
        if (pageFormats == null) {
            pageFormats = new Page[4];
            PrintTools.pageFormats[0] = PrintTools.getA5PageFormat();
            PrintTools.pageFormats[1] = PrintTools.getA4PageFormat();
            PrintTools.pageFormats[2] = PrintTools.getA3PageFormat();
            PrintTools.pageFormats[3] = PrintTools.getLetterPageFormat();
        }
        return pageFormats;
    }

    public static Page getA5PageFormat() {
        if (a5 == null) {
            a5 = new Page("DIN A5 (148 x 210 mm)");
            Paper paper = new Paper();
            paper.setSize(PrintTools.milimeter2Dots(148.0), PrintTools.milimeter2Dots(210.0));
            paper.setImageableArea(PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(128.0), PrintTools.milimeter2Dots(190.0));
            a5.setPaper(paper);
            a5.setOrientation(1);
        }
        return a5;
    }

    public static Page getA4PageFormat() {
        if (a4 == null) {
            a4 = new Page("DIN A4 (210 x 297 mm)");
            Paper paper = new Paper();
            paper.setSize(PrintTools.milimeter2Dots(210.0), PrintTools.milimeter2Dots(297.0));
            paper.setImageableArea(PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(190.0), PrintTools.milimeter2Dots(277.0));
            a4.setPaper(paper);
            a4.setOrientation(1);
        }
        return a4;
    }

    public static Page getA3PageFormat() {
        if (a3 == null) {
            a3 = new Page("DIN A3 (297 x 420 mm)");
            Paper paper = new Paper();
            paper.setSize(PrintTools.milimeter2Dots(297.0), PrintTools.milimeter2Dots(420.0));
            paper.setImageableArea(PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(10.0), PrintTools.milimeter2Dots(277.0), PrintTools.milimeter2Dots(400.0));
            a3.setPaper(paper);
            a3.setOrientation(1);
        }
        return a3;
    }

    public static Page getLetterPageFormat() {
        if (letter == null) {
            letter = new Page("Letter (8 1/2 x 11 in)");
            Paper paper = new Paper();
            paper.setSize(PrintTools.inches2Dots(8.5), PrintTools.inches2Dots(11.0));
            paper.setImageableArea(PrintTools.inches2Dots(1.0), PrintTools.inches2Dots(1.0), PrintTools.inches2Dots(6.5), PrintTools.inches2Dots(9.0));
            letter.setPaper(paper);
            letter.setOrientation(1);
        }
        return letter;
    }
}

