/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.GuiElement;
import ch.e2e.ant.gui.configuration.types.display.Message;
import ch.e2e.ant.gui.configuration.types.input.DirectoryComboBox;
import ch.e2e.ant.gui.configuration.types.input.DirectoryInputField;
import ch.e2e.ant.gui.configuration.types.input.DirectoryList;
import ch.e2e.ant.gui.configuration.types.input.DirectoryTree;
import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.event.DirectoryActionEvent;
import ch.e2e.swing.event.DirectoryActionListener;
import ch.e2e.swing.filechooser.NewDirectoryDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FolderSelection
extends InputElement
implements DirectoryActionListener,
InputFieldListener {
    private NewDirectoryDialog newDirectoryDialog;
    private JPanel folderPanel;
    private DirectoryTree tree;
    private File startDir;
    private File root;
    private ArrayList elements = new ArrayList();
    private DirectoryComboBox comboBox;
    private DirectoryInputField textInput;
    private DirectoryList list;

    public FolderSelection() {
        this.setFill("both");
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public void updateRoot(File root) {
        this.setRoot(root);
    }

    public void setStartDir(File startDir) {
        this.startDir = startDir;
    }

    public void updateStartDir(File startDir) {
        this.setStartDir(startDir);
    }

    public void addMessage(Message message) {
        this.elements.add(message);
    }

    public void addTree(DirectoryTree tree) {
        this.tree = tree;
        this.elements.add(tree);
    }

    public void addComboBox(DirectoryComboBox comboBox) {
        this.comboBox = comboBox;
        this.elements.add(comboBox);
    }

    public void addTextInput(DirectoryInputField textInput) {
        this.textInput = textInput;
        this.elements.add(textInput);
    }

    public void addList(DirectoryList list) {
        this.list = list;
        this.elements.add(list);
    }

    @Override
    public JComponent getGuiElement() {
        if (this.folderPanel == null) {
            this.createFolderPanel();
        }
        return this.folderPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        int length = this.elements.size();
        for (int i = 0; i < length; ++i) {
            GuiElement element = (GuiElement)this.elements.get(i);
            if (!(element instanceof InputElement)) continue;
            ((InputElement)element).setEnabled(enabled);
        }
    }

    private void createFolderPanel() {
        this.folderPanel = new JPanel(new GridBagLayout());
        if (this.elements.size() == 0) {
            throw new ConfigurationParseException("A textinput, tree, list or combobox elements must be specified in the folderselection.");
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 5, 0);
        int length = this.elements.size();
        boolean weighty = false;
        for (int i = 0; i < length; ++i) {
            GuiElement element = (GuiElement)this.elements.get(i);
            JComponent component = element.getComponent();
            c.fill = element.getFill();
            if (c.fill == 3 || c.fill == 1) {
                c.weighty = 1.0;
                weighty = true;
            }
            if (i == length - 1) {
                c.insets = new Insets(0, 0, 0, 0);
                if (!weighty) {
                    c.weighty = 1.0;
                }
            }
            this.folderPanel.add((Component)component, c);
            c.weighty = 0.0;
        }
        this.prepareEventHandling();
    }

    private void prepareEventHandling() {
        if (this.comboBox != null) {
            this.setComboboxEventHandling();
        }
        if (this.tree != null) {
            this.setTreeEventHandling();
        }
        if (this.textInput != null) {
            this.setTextInputEventHandling();
        }
        if (this.list != null) {
            this.setListEventHandling();
        }
    }

    private void setComboboxEventHandling() {
        this.comboBox.addInputFieldListener(this);
        this.comboBox.addDirectoryActionListener(this);
        this.comboBox.setSelectedDirectory(this.startDir);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderSelection.this.fireAction(e);
            }
        });
    }

    private void setTreeEventHandling() {
        this.tree.addInputFieldListener(this);
        this.tree.setRoot(this.root);
        this.tree.setSelectedDirectory(this.startDir);
        this.tree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderSelection.this.fireAction(e);
            }
        });
        if (this.comboBox != null) {
            this.comboBox.addDirectoryListener(this.tree.getTree());
        }
    }

    private void setTextInputEventHandling() {
        this.textInput.addInputFieldListener(this);
        this.textInput.setRoot(this.root);
        this.textInput.setSelectedDirectory(this.startDir);
        this.textInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderSelection.this.fireAction(e);
            }
        });
        if (this.comboBox != null) {
            this.comboBox.addDirectoryListener(this.textInput.getField());
        }
        if (this.tree != null) {
            this.tree.addDirectoryListener(this.textInput.getField());
        }
    }

    private void setListEventHandling() {
        this.list.setRoot(this.root);
        this.list.setSelectedDirectory(this.startDir);
        if (this.comboBox != null) {
            this.comboBox.addDirectoryListener(this.list);
        }
        if (this.tree != null) {
            this.tree.addDirectoryListener(this.list);
        }
        if (this.textInput != null) {
            this.textInput.addDirectoryListener(this.list);
        }
        this.list.addInputFieldListener(this);
        this.list.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderSelection.this.fireAction(e);
            }
        });
    }

    @Override
    public String getValue() {
        String result = null;
        if (this.textInput != null) {
            result = this.textInput.getValue();
        } else if (this.tree != null) {
            result = this.tree.getValue();
        } else if (this.comboBox != null) {
            result = this.comboBox.getValue();
        } else if (this.list != null) {
            result = this.list.getValue();
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.textInput.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.textInput.requestFocus();
    }

    public void createNewDirectory(DirectoryActionEvent event) {
        File newDirectory;
        if (this.newDirectoryDialog == null) {
            this.newDirectoryDialog = new NewDirectoryDialog(ConfigurationTools.getInstance().getDialogParent());
        }
        if ((newDirectory = this.newDirectoryDialog.getNewDirectory(event.getDirectory().getDir())) != null) {
            if (!newDirectory.exists()) {
                newDirectory.mkdirs();
                if (this.tree != null) {
                    this.tree.refresh();
                }
            }
            this.comboBox.setSelectedDirectory(newDirectory);
        }
    }

    public void deleteDirectory(DirectoryActionEvent event) {
    }

    public void inputFieldChanged(InputFieldEvent event) {
        this.fireInputFieldChanged(this);
    }
}

