/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.InputList;
import ch.e2e.swing.InputListCellRenderer;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.model.Directory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class DirectoryList
extends InputElement
implements InputFieldListener,
DirectorySelectedListener {
    private InputList list;
    private JScrollPane scrollPane;
    private DirectorySelectedListener listener;
    private String icon;

    @Override
    public JComponent getGuiElement() {
        if (this.list == null) {
            this.list = new InputList();
            this.list.addInputFieldListener((InputFieldListener)this);
            if (this.icon != null) {
                ((InputListCellRenderer)this.list.getCellRenderer()).setIcon((Icon)ImageLoader.loadIcon((String)this.icon, (boolean)true));
            }
            this.list.setSelectionMode(0);
            this.list.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryList.this.fireAction(e);
                }
            });
            this.scrollPane = new JScrollPane((Component)this.list);
        }
        return this.scrollPane;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setRoot(File root) {
        Directory dir = Directory.getDirectory((File)root);
        ArrayList subdirs = dir.getSubdirs();
        this.list.setListData(subdirs.toArray());
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.list.setSelectedValue((Object)Directory.getDirectory((File)selectedDirectory), true);
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.listener = DirectorySelectedEventMulticaster.addListener((DirectorySelectedListener)this.listener, (DirectorySelectedListener)listener);
    }

    @Override
    public String getValue() {
        Directory selectedValue = (Directory)this.list.getSelectedValue();
        return selectedValue == null ? null : selectedValue.getDir().getAbsolutePath();
    }

    @Override
    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.list.requestFocus();
    }

    public void inputFieldChanged(InputFieldEvent e) {
        if (this.listener != null) {
            this.listener.directorySelected(new DirectorySelectedEvent((Object)this, (Directory)this.list.getSelectedValue()));
        }
        this.fireInputFieldChanged(this);
    }

    public void directorySelected(DirectorySelectedEvent event) {
        this.list.setSelectedValue((Object)event.getDirectory(), true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }
}

