/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui;

import ch.e2e.ant.gui.AntConsole;
import ch.e2e.ant.gui.AntConsoleImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class AntConsoleFactory {
    public static final String ANTCONSOLE_SEARCH = "ch.e2e.ant.gui.AntConsole";
    private static AntConsole singleConsoleInstance;

    private AntConsoleFactory() {
    }

    public static AntConsole getConsoleInstance() {
        if (singleConsoleInstance == null) {
            singleConsoleInstance = AntConsoleFactory.newConsoleInstance();
        }
        return singleConsoleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntConsole newConsoleInstance() {
        AntConsole result = null;
        String consoleName = System.getProperty(ANTCONSOLE_SEARCH);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (consoleName == null) {
            String searchString = "META-INF/services/ch.e2e.ant.gui.AntConsole";
            InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(searchString) : classLoader.getResourceAsStream(searchString);
            if (is != null) {
                BufferedReader rd = null;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    consoleName = rd.readLine();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        rd.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (consoleName != null) {
            result = AntConsoleFactory.createAntConsole(classLoader, consoleName, result);
        }
        if (result == null) {
            result = new AntConsoleImpl();
        }
        return result;
    }

    private static AntConsole createAntConsole(ClassLoader classLoader, String consoleName, AntConsole result) {
        try {
            Class<?> clazz = classLoader == null ? ClassLoader.getSystemClassLoader().loadClass(consoleName) : classLoader.loadClass(consoleName);
            if (clazz != null) {
                result = (AntConsole)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

