/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.message;

import ch.e2e.builder.base.message.MessageGroupsPool;
import ch.e2e.builder.base.message.MessageTypesPool;
import ch.e2e.builder.base.message.XSLTMessageGroup;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.base.xsltinterface.XSLTAction;
import ch.e2e.swing.Message;
import ch.e2e.swing.MessageGroup;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class E2EBuilderMessage
extends Message {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss ");
    private String module;
    private Date date;

    public E2EBuilderMessage(Object source, String code, String module) {
        this(source, code, new HashMap<String, String>(), null, module);
    }

    public E2EBuilderMessage(Object source, String code, Map<String, String> parameter, String type, String module) {
        this(source, code, null, parameter, type, module);
    }

    public E2EBuilderMessage(Object source, String code, MessageGroup group, Map<String, String> parameter, String type, String module) {
        super(code, group, parameter, MessageTypesPool.getMessageType(module, type));
        this.module = module;
        this.date = new Date();
        if (source instanceof XSLTAction) {
            XSLTAction xsltAction = (XSLTAction)source;
            MessageGroup messageGroup = MessageGroupsPool.getInstance().getMessageGroup(module, xsltAction.getName(), xsltAction.getMessageGroupType());
            this.setGroup(messageGroup);
            if (messageGroup instanceof XSLTMessageGroup) {
                ((XSLTMessageGroup)messageGroup).setXSLTAction(xsltAction);
            }
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    protected String getMessagePrefix() {
        return dateFormatter.format(this.date);
    }

    public String getMessage() {
        return this.getMessagePrefix() + this.getParameterizedMessage(E2EBuilderTranslator.getModuleTranslation(this.module, this.getCode() + ".short", this.getCode()));
    }

    protected String getParameterizedMessage(String message) {
        message = E2EBuilderTranslator.getModuleTranslation(this.module, message, message);
        return super.getParameterizedMessage(message);
    }

    public String getModule() {
        return this.module;
    }
}

