/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.ErrorHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BuilderException
extends AbstractBuilderError {
    @XmlElementWrapper
    @XmlElement(name="line")
    private String[] stacktrace;
    @XmlElement
    private String message;

    private BuilderException() {
        super(null, Collections.emptyMap());
    }

    public BuilderException(Element errorElement) {
        super(errorElement);
        Element stacktraceElement;
        NodeList lines;
        NodeList stacktraceElements;
        NodeList messages = errorElement.getElementsByTagName("Message");
        if (messages != null && messages.getLength() == 1) {
            this.message = ErrorHelper.getText((Element)messages.item(0));
        }
        if ((stacktraceElements = errorElement.getElementsByTagName("Stacktrace")) != null && stacktraceElements.getLength() > 0 && (lines = (stacktraceElement = (Element)stacktraceElements.item(0)).getElementsByTagName("Line")) != null) {
            int length = lines.getLength();
            this.stacktrace = new String[length];
            for (int i = 0; i < length; ++i) {
                this.stacktrace[i] = ErrorHelper.getText((Element)lines.item(i));
            }
        }
    }

    public BuilderException(Throwable exception) {
        this(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage(), exception);
    }

    public BuilderException(String code, Throwable exception) {
        super(code, new HashMap<String, String>());
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        StringTokenizer tokenizer = new StringTokenizer(writer.toString(), "\n\r\t");
        ArrayList<String> stackTraceLines = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            if (tokenizer.hasMoreTokens()) {
                stackTraceLines.add(tokenizer.nextToken());
                continue;
            }
            i = 10;
        }
        this.stacktrace = new String[stackTraceLines.size()];
        stackTraceLines.toArray(this.stacktrace);
        this.message = exception.getClass().getName() + ": " + exception.getMessage();
    }

    @Override
    public Element toNode(Document parent) {
        Element errorElement = super.toNode(parent);
        Element message = parent.createElement("Message");
        message.appendChild(parent.createTextNode(this.message));
        errorElement.appendChild(message);
        Element stacktraceElement = parent.createElement("Stacktrace");
        for (String aStacktrace : this.stacktrace) {
            Element line = parent.createElement("Line");
            line.appendChild(parent.createTextNode(aStacktrace));
            stacktraceElement.appendChild(line);
        }
        errorElement.appendChild(stacktraceElement);
        return errorElement;
    }

    public String[] getStacktrace() {
        return this.stacktrace;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getType() {
        return 9000;
    }
}

