/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.E2EBuilderInputDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.event.EventExecuter;
import java.awt.Color;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public abstract class TestcaseExecuter
implements EventExecuter {
    private static JPanel warning = null;
    private String key;
    private E2EBuilderModule module;
    private String inputPattern;

    public TestcaseExecuter(String key, String inputPattern, E2EBuilderModule traceViewer) {
        this.key = key;
        this.module = traceViewer;
        this.inputPattern = inputPattern;
        if (warning == null) {
            warning = new JPanel();
            String msg = traceViewer.getTranslation("testcase.copy.warning", "Copying a testcase to a different WSDL/location may result in runtime errors.");
            JTextField comp = new JTextField(msg);
            comp.setForeground(new Color(0xBB0000));
            comp.setEditable(false);
            comp.setOpaque(false);
            comp.setBorder(new EmptyBorder(0, 0, 0, 0));
            warning.add(comp);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void execute(EventObject event) {
        if (((TestcaseEvent)event).getTestcaseObject() instanceof AbstractSynchronousTestcase) {
            AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)((TestcaseEvent)event).getTestcaseObject();
            this.execute(testcase);
        }
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    protected void execute(AbstractSynchronousTestcase testcase) {
        AbstractTestcaseFolder testcaseFolder;
        String name = this.getUniqueTestcasename(this.key, testcase);
        if (name != null && !(testcaseFolder = (AbstractTestcaseFolder)testcase.getParent()).exists(name)) {
            try {
                this.execute(name, testcase);
            }
            catch (Exception e) {
                this.module.showError(e.toString());
            }
        }
    }

    protected void execute(AbstractSynchronousTestcase testcase, AbstractTestcaseFolder testcaseFolder) {
        String name = this.getUniqueTestcasename(this.key, testcase, testcaseFolder);
        if (name != null && !testcaseFolder.exists(name)) {
            try {
                this.execute(name, testcase, testcaseFolder);
            }
            catch (Exception e) {
                this.module.showError(e.toString());
            }
        }
    }

    protected void execute(String name, AbstractSynchronousTestcase testcase) throws IOException {
    }

    protected void execute(String name, AbstractSynchronousTestcase testcase, AbstractTestcaseFolder testcaseFolder) throws IOException {
    }

    final String getTestcasename(String key, String defaultName) {
        return this.getTestcasename(key, defaultName, false);
    }

    final String getTestcasename(String key, String defaultName, boolean showWarning) {
        String message = this.module.getTranslation("testcase." + key + ".name.message");
        String title = this.module.getTranslation("testcase." + key + ".name.title");
        String subtitle = this.module.getTranslation("testcase." + key + ".name.internaltitle");
        String internaltitle = this.module.getTranslation("testcase." + key + ".name.subtitle");
        return E2EBuilderInputDialog.getInput((String)message, (String)defaultName, (String)title, (String)internaltitle, (String)subtitle, (String)this.inputPattern, (boolean)false, (JPanel)(showWarning ? warning : null), null, null, null, (int)-1);
    }

    protected String getUniqueTestcasename(String key, AbstractTestcaseFolder parent) {
        String name = this.getTestcasename(key, parent.findDefaultTestcaseName());
        if (name != null && parent.exists(name)) {
            String message = this.module.getTranslation("testcase." + key + ".error.exists.message");
            String title = this.module.getTranslation("testcase." + key + ".error.exists.title");
            String subtitle = this.module.getTranslation("testcase." + key + ".error.exists.internaltitle");
            String internaltitle = this.module.getTranslation("testcase." + key + ".error.exists.subtitle");
            E2EBuilderInfoDialog.error((String)title, (String)internaltitle, (String)subtitle, (String)message);
            name = this.getUniqueTestcasename(key, parent);
        }
        return name;
    }

    protected String getUniqueTestcasename(String key, AbstractSynchronousTestcase testcase) {
        return this.getUniqueTestcasename(key, testcase, (AbstractTestcaseFolder)testcase.getParent());
    }

    protected String getUniqueTestcasename(String key, AbstractSynchronousTestcase testcase, AbstractTestcaseFolder testcaseFolder) {
        boolean getNewName;
        String name = key.equals("rename") ? testcase.getName() : testcaseFolder.findUniqueTestcaseName(testcase.getName());
        boolean showWarning = !testcaseFolder.equals((Object)testcase.getParent());
        if ((name = this.getTestcasename(key, name, showWarning)) != null && (getNewName = key.equals("rename") ? !name.equals(testcase.getName()) && testcaseFolder.exists(name) : testcaseFolder.exists(name))) {
            String message = this.module.getTranslation("testcase." + key + ".error.exists.message");
            String title = this.module.getTranslation("testcase." + key + ".error.exists.title");
            String subtitle = this.module.getTranslation("testcase." + key + ".error.exists.internaltitle");
            String internaltitle = this.module.getTranslation("testcase." + key + ".error.exists.subtitle");
            E2EBuilderInfoDialog.error((String)title, (String)internaltitle, (String)subtitle, (String)message);
            name = this.getUniqueTestcasename(key, testcase);
        }
        return name;
    }
}

