/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.execute.TestcaseNoTraceRunTransaction;
import ch.e2e.builder.trace.execute.TestcaseRunListener;
import ch.e2e.builder.trace.execute.TestcaseRunTransaction;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.builder.trace.tree.RunTestcaseRejectedEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RunTestcaseExecuter
implements EventExecuter {
    private static final Map<String, ExecutorService> executorServices = new HashMap<String, ExecutorService>();
    private E2EBuilderModule module;

    public RunTestcaseExecuter(E2EBuilderModule module) {
        this.module = module;
    }

    public synchronized void execute(EventObject event) {
        AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)((TestcaseEvent)event).getTestcaseObject();
        this.runTestcase(testcase, null);
    }

    public void runTestcase(AbstractSynchronousTestcase testcase, Collection<? extends TestcaseRunListener> runListeners) {
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new TestcaseRunTransaction(this.module, runListeners), (Object)testcase));
    }

    public void runTestcaseEmbedded(AbstractSynchronousTestcase testcase, Collection<? extends TestcaseRunListener> runListeners) {
        this.runEmbedded(new TestcaseNoTraceRunTransaction(this.module, runListeners), testcase);
    }

    private void runEmbedded(final TestcaseNoTraceRunTransaction transaction, final AbstractSynchronousTestcase testcase) {
        try {
            this.getExecutorService((Testcase)testcase).execute(new Runnable(){

                @Override
                public void run() {
                    transaction.prepareTransaction();
                    Object result = transaction.doTransaction(testcase);
                    transaction.setTransactionResult(result);
                }
            });
        }
        catch (RejectedExecutionException e) {
            EventController.fire((EventObject)new RunTestcaseRejectedEvent(testcase, this.module));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(Testcase testcase) {
        String location = testcase.getLocation();
        ExecutorService executorService = executorServices.get(location);
        if (executorService == null) {
            Map<String, ExecutorService> map = executorServices;
            synchronized (map) {
                executorService = executorServices.get(location);
                if (executorService == null) {
                    executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
                    executorServices.put(location, executorService);
                }
            }
        }
        return executorService;
    }
}

