/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.watch.WatchRenderer;
import ch.e2e.builder.trace.gui.watch.WatchTreeModel;
import ch.e2e.builder.trace.testcase.AddWatchResult;
import ch.e2e.builder.trace.testcase.FlowNotInspectedException;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.DockableFrame;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WatchView
extends DockableFrame {
    private WatchTreeModel treeModel;
    private Tree tree;
    private Testcase testcase;
    private long runDate = -1L;

    public WatchView(E2ETraceModule module) {
        super(module.getTranslation("testcase.watch.view.name"), (Icon)ImageLoader.loadIcon((String)"ch/e2e/builder/trace/images/watches.icon.gif", (boolean)false, (ClassLoader)WatchView.class.getClassLoader()), false);
        this.createGui(module);
        this.tree.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                WatchView.this.doPopupAction(e);
            }
        });
    }

    public void setTestcase(Testcase testcase) {
        this.testcase = testcase;
        this.treeModel.setRoot(testcase);
        if (testcase == null) {
            this.runDate = -1L;
        } else {
            this.runDate = testcase.getRunDate();
            this.treeModel.refresh();
        }
        this.setTitle("Watches (" + testcase + ")");
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    public void addWatch(URL url, String diagramName) throws FlowNotInspectedException {
        AddWatchResult watch = this.testcase.addWatch(url, diagramName);
        if (watch != null) {
            if (watch.isNew()) {
                this.update(watch.getWatch());
            } else {
                this.selectAndExpand(watch.getWatch());
            }
        }
    }

    private void update(TestcaseWatch watch) {
        final List expandedPaths = this.tree.getExpandedRows();
        final TreePath watchPath = new TreePath(new Object[]{this.testcase, watch});
        this.treeModel.refresh();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WatchView.this.tree.expandRows(expandedPaths);
                WatchView.this.tree.expandPath(watchPath);
                WatchView.this.selectPath(watchPath);
            }
        });
    }

    public void selectAndExpand(TestcaseWatch watch) {
        final TreePath watchPath = new TreePath(new Object[]{this.testcase, watch});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WatchView.this.tree.expandPath(watchPath);
                WatchView.this.selectPath(watchPath);
            }
        });
    }

    private void selectPath(TreePath watchPath) {
        this.tree.setSelectionPath(watchPath);
        this.tree.scrollPathToVisible(watchPath);
    }

    private void createGui(E2ETraceModule module) {
        this.setLayout(new BorderLayout());
        this.treeModel = new WatchTreeModel(module);
        WatchRenderer cellRenderer = new WatchRenderer(new RendererPreferences((AbstractTreeModel)this.treeModel));
        this.tree = new Tree((AbstractTreeModel)this.treeModel, (TreeCellRenderer)cellRenderer);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setBackground(Color.WHITE);
        this.tree.setOpaque(true);
        this.tree.setTransferHandler((TransferHandler)new ParameterTransferHandler());
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add(scrollPane, "Center");
    }

    private void doPopupAction(MouseEvent e) {
        TreePath path;
        if ((e.isPopupTrigger() || e.getButton() == 3) && (path = this.tree.getPathForLocation(e.getX(), e.getY())) == null) {
            this.treeModel.getPopupMenu(null).show((Component)this.tree, e.getX(), e.getY());
        }
    }
}

