/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.trace.gui.tree.ParameterRenderer;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.resource.Properties;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellRenderer;

public class WatchRenderer
extends ParameterRenderer
implements TreeCellRenderer {
    private JLabel valueLabel;
    private JLabel defaultLabel;
    private RendererPreferences preferences;
    private Color selectedBorder;
    private Color valueColor;

    public WatchRenderer(RendererPreferences preferences) {
        super(preferences);
        this.preferences = preferences;
        this.createGui(preferences.getProperties());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JComponent result;
        if (value instanceof TestcaseParameter) {
            int type = this.preferences.getType(value);
            this.setIcon(type, leaf, expanded, selected);
            TestcaseParameter parameter = (TestcaseParameter)value;
            this.setLabelVisibility(parameter);
            if (parameter.hasItems() || parameter.getType() == 10009) {
                this.valueLabel.setText("");
            } else {
                this.valueLabel.setText(parameter.getDisplayValue());
            }
            if (selected) {
                this.setSelectedColors();
                this.setSelectedValueColors();
                if (hasFocus) {
                    this.labelPanel.setBorder(new LineBorder(this.selectedBorder, 1));
                } else {
                    this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
                }
            } else {
                this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
                this.setUnselectedColors();
                this.setUnselectedValueColors();
                Color color = this.preferences.getColor(type, leaf, expanded);
                if (type == 10048 && color != null) {
                    this.getNameLabel().setForeground(color);
                    this.getTypeLabel().setForeground(color);
                }
            }
            result = this;
        } else {
            this.defaultLabel.setText(this.preferences.toString(value));
            result = this.defaultLabel;
        }
        this.setToolTipText(this.preferences.getTooltip(value));
        return result;
    }

    private void setUnselectedValueColors() {
        this.valueLabel.setBackground(this.unselectedBackground);
        this.valueLabel.setForeground(this.valueColor);
    }

    private void setSelectedValueColors() {
        this.valueLabel.setBackground(this.selectedBackground);
        this.valueLabel.setForeground(this.selectedForeground);
    }

    private void createGui(Properties properties) {
        this.selectedBorder = UIManager.getColor("Tree.selectionBorderColor");
        this.valueColor = properties.getColor("watches.value.color");
        this.valueLabel = this.createLabel("");
        this.addEditor(this.valueLabel);
        this.defaultLabel = new JLabel();
    }
}

