/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.state.AbstractStateCell;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.TargetState;
import ch.e2e.builder.trace.testcase.uml.TargetStateParent;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Map;
import org.jgraph.graph.Port;

public class StateCell
extends AbstractStateCell
implements CellWithContextMenu {
    private static StateContextMenu contextMenu;
    private GenericFlow entryFlow;
    private GenericFlow exitFlow;
    private GenericFlow doFlow;
    private E2EBuilderModule module;

    public StateCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.initialize();
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Port getEntryPort() {
        return (Port)this.getChildAt(0);
    }

    @Override
    public Port getExitPort() {
        return (Port)this.getChildAt(1);
    }

    public GenericFlow getEntryFlow() {
        return this.entryFlow;
    }

    public void setEntryFlow(GenericFlow entryFlow) {
        this.entryFlow = entryFlow;
    }

    public GenericFlow getExitFlow() {
        return this.exitFlow;
    }

    public void setExitFlow(GenericFlow exitFlow) {
        this.exitFlow = exitFlow;
    }

    public GenericFlow getDoFlow() {
        return this.doFlow;
    }

    public void setDoFlow(GenericFlow doFlow) {
        this.doFlow = doFlow;
    }

    private boolean isCompositeState() {
        return this.userObject instanceof TargetStateParent || this.userObject instanceof TargetState && ((TargetState)this.userObject).hasDiagram();
    }

    private void initialize() {
        this.addPort(new Point2D.Double(500.0, 0.0));
        this.addPort(new Point2D.Double(500.0, 1000.0));
        UmlGraphConstants.setShowStereotype((Map)this.attributes, false);
        UmlGraphConstants.setOpaque((Map)this.attributes, (boolean)true);
        UmlGraphConstants.setBackground((Map)this.attributes, (Color)UmlGraphConstants.STATE_COLOR);
        UmlGraphConstants.setGradientColor((Map)this.attributes, (Color)UmlGraphConstants.STATE_GRADIENT_COLOR);
        UmlGraphConstants.setBorderColor((Map)this.attributes, (Color)Color.BLACK);
        UmlGraphConstants.setRoundedCorners((Map)this.attributes, true);
        UmlGraphConstants.setBounds((Map)this.attributes, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 120.0, 50.0));
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public StateContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new StateContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    @Override
    public AbstractCellAction<? extends CellWithContextMenu> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private static class StateContextMenu
    extends ContextMenu<StateCell> {
        public StateContextMenu(StateCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(StateCell cell) {
            super.setCell(cell);
            if (cell.isCompositeState()) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.substate"));
            } else {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.in.tree"));
            }
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.entry.behavior"), (UmlObject)cell.getEntryFlow(), cell.getEntryFlow() != null);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.state.behavior"), (UmlObject)cell.getDoFlow(), cell.getDoFlow() != null);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.exit.behavior"), (UmlObject)cell.getExitFlow(), cell.getExitFlow() != null);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.substate"), cell.isCompositeState());
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<StateCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((StateCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<StateCell>(this.getTranslation("uml.diagram.action.show.entry.behavior")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericFlow flow = ((StateCell)this.getCell()).getEntryFlow();
                    if (flow != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openActivity?activity=" + flow.getOriginalName()));
                    }
                }
            });
            this.addItem(new AbstractCellAction<StateCell>(this.getTranslation("uml.diagram.action.show.state.behavior")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericFlow flow = ((StateCell)this.getCell()).getDoFlow();
                    if (flow != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openActivity?activity=" + flow.getOriginalName()));
                    }
                }
            });
            this.addItem(new AbstractCellAction<StateCell>(this.getTranslation("uml.diagram.action.show.exit.behavior")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericFlow flow = ((StateCell)this.getCell()).getExitFlow();
                    if (flow != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openActivity?activity=" + flow.getOriginalName()));
                    }
                }
            });
            this.addItem(new AbstractCellAction<StateCell>(this.getTranslation("uml.diagram.action.show.substate")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((StateCell)this.getCell()).isCompositeState()) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openState?state=" + ((UmlObject)((StateCell)this.getCell()).userObject).getOriginalName()));
                    }
                }
            });
        }
    }
}

