/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.tree;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.TestcaseTransferable;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class TestcasePopupMenu
extends ModulePopupMenu {
    private AbstractSynchronousTestcase testcase;
    private AbstractSynchronousTestcase clipboardTestcase;
    private final JMenuItem run;
    private final JMenuItem paste;
    private JMenuItem mockBackendsManually;

    public TestcasePopupMenu(E2EBuilderModule module, final TestcaseTreeListener testcaseListener) {
        super(module);
        this.run = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.run", (E2EBuilderModule)module);
        this.run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.runTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(this.run);
        JMenuItem clear = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.clear", (E2EBuilderModule)module);
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.clearTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(clear);
        this.addSeparator();
        JMenuItem duplicate = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.duplicate", (E2EBuilderModule)module);
        duplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.copyTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(duplicate);
        JMenuItem copy = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.copy", (E2EBuilderModule)module);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = TestcasePopupMenu.this.getToolkit().getSystemClipboard();
                if (clipboard != null) {
                    clipboard.setContents(new TestcaseTransferable(TestcasePopupMenu.this.testcase), null);
                }
            }
        });
        this.add(copy);
        this.paste = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.paste", (E2EBuilderModule)module);
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestcasePopupMenu.this.clipboardTestcase != null) {
                    testcaseListener.copyTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.clipboardTestcase, (AbstractTestcaseFolder)TestcasePopupMenu.this.testcase.getParent()));
                }
            }
        });
        this.add(this.paste);
        JMenuItem rename = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.rename", (E2EBuilderModule)module);
        rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.renameTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(rename);
        JMenuItem delete = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.delete", (E2EBuilderModule)module);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.deleteTestcase(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(delete);
        this.addSeparator();
        this.addMockItems(module, testcaseListener);
        this.addSeparator();
        JMenuItem properties = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.properties", (E2EBuilderModule)module);
        properties.setFont(properties.getFont().deriveFont(1));
        properties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.editPreferences(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(properties);
    }

    public AbstractSynchronousTestcase getTestcase() {
        return this.testcase;
    }

    public void setPath(TreePath path) {
        this.testcase = (AbstractSynchronousTestcase)path.getLastPathComponent();
        try {
            this.run.setEnabled(!this.testcase.getRequest().hasErrors());
        }
        catch (Exception e) {
            this.run.setEnabled(true);
        }
        this.clipboardTestcase = this.getTestcaseFromClipboard();
        this.paste.setEnabled(this.clipboardTestcase != null);
        this.mockBackendsManually.setEnabled(this.testcase.hasAdapterTemplates());
    }

    protected void addMockItems(E2EBuilderModule module, final TestcaseTreeListener testcaseListener) {
        this.mockBackendsManually = ComponentFactory.createMenuItem((String)"tree.testcase.popup.menu.mock.backends.manually", (E2EBuilderModule)module);
        this.mockBackendsManually.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                testcaseListener.mockBackendsManually(new TestcaseTreeEvent((Object)TestcasePopupMenu.this, TestcasePopupMenu.this.testcase));
            }
        });
        this.add(this.mockBackendsManually);
    }

    private AbstractSynchronousTestcase getTestcaseFromClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard != null) {
            try {
                Object data = clipboard.getData(TestcaseTransferable.testcaseFlavor);
                return data instanceof AbstractSynchronousTestcase ? (AbstractSynchronousTestcase)data : null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

