/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.menu;

import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.ArrayParameter;
import ch.e2e.builder.trace.testcase.parameter.BlobParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class ParameterPopupMenu
extends ModulePopupMenu {
    private JMenuItem setNullItem;
    private JMenuItem insertBeforeItem;
    private JMenuItem insertBehindItem;
    private TestcaseParameter parameter;
    private TreePath treePath;
    private JMenuItem deleteItem;
    private JPopupMenu.Separator separator;
    private JMenuItem pasteValueItem;
    private JMenuItem chooseFileItem;
    private ParameterTransferHandler transferHandler;
    private final AbstractTreeModel treeModel;
    private File lastDir;
    private JMenuItem copyValueItem;

    public ParameterPopupMenu(AbstractTreeModel treeModel, E2EBuilderModule module) {
        super(module);
        this.treeModel = treeModel;
        this.transferHandler = new ParameterTransferHandler();
        this.addItems(module);
    }

    public void setParameter(TestcaseParameter parameter, TreePath treePath) {
        this.parameter = parameter;
        this.treePath = treePath;
        this.transferHandler.setParameter(parameter);
        this.setNullItem.setVisible(!parameter.isNull());
        this.copyValueItem.setVisible(parameter instanceof SimpleTypeParameter);
        this.pasteValueItem.setVisible(parameter instanceof SimpleTypeParameter);
        this.pasteValueItem.setEnabled(this.pasteValueItem.getToolkit().getSystemClipboard().getContents((Object)this) != null);
        this.chooseFileItem.setVisible(parameter instanceof BlobParameter);
        this.separator.setVisible(parameter.isArrayItem());
        this.deleteItem.setVisible(parameter.isArrayItem());
        this.insertBeforeItem.setVisible(parameter.isArrayItem());
        this.insertBehindItem.setVisible(parameter.isArrayItem());
    }

    public TestcaseParameter getParameter() {
        return this.parameter;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public final boolean hasVisibleItems(TestcaseParameter parameter) {
        return this.getVisibleItems(parameter) != 0;
    }

    protected int getVisibleItems(TestcaseParameter parameter) {
        int result;
        int n = result = parameter.isNull() ? 1 : 3;
        if (parameter.isArrayItem()) {
            result += 2;
        }
        return result;
    }

    private void addItems(final E2EBuilderModule module) {
        this.insertBeforeItem = module.createMenuItem("testcase.request.parameter.popup.insert.before.item");
        this.insertBeforeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayParameter parent = (ArrayParameter)((Parameter)ParameterPopupMenu.this.parameter).getParent();
                Parameter insertedParameter = parent.insertBefore((Parameter)ParameterPopupMenu.this.parameter);
                int index = parent.getIndexOfChild((Object)insertedParameter);
                ParameterPopupMenu.this.treeModel.nodeInserted(ParameterPopupMenu.this.treePath.getParentPath(), index, (Object)insertedParameter);
            }
        });
        this.add(this.insertBeforeItem);
        this.insertBehindItem = module.createMenuItem("testcase.request.parameter.popup.insert.behind.item");
        this.insertBehindItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayParameter parent = (ArrayParameter)((Parameter)ParameterPopupMenu.this.parameter).getParent();
                Parameter insertedParameter = parent.insertBehind((Parameter)ParameterPopupMenu.this.parameter);
                int index = parent.getIndexOfChild((Object)insertedParameter);
                ParameterPopupMenu.this.treeModel.nodeInserted(ParameterPopupMenu.this.treePath.getParentPath(), index, (Object)insertedParameter);
            }
        });
        this.add(this.insertBehindItem);
        this.separator = new JPopupMenu.Separator();
        this.add(this.separator);
        this.setNullItem = module.createMenuItem("testcase.request.parameter.popup.set.null");
        this.setNullItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPopupMenu.this.parameter.setValue(null);
                ParameterPopupMenu.this.treeModel.nodeStructureChanged(ParameterPopupMenu.this.treePath);
            }
        });
        this.add(this.setNullItem);
        this.copyValueItem = module.createMenuItem("testcase.request.parameter.popup.value.copy");
        this.copyValueItem.setAction(new AbstractAction(this.copyValueItem.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferHandler.getCopyAction().actionPerformed(e);
            }
        });
        this.copyValueItem.setTransferHandler((TransferHandler)this.transferHandler);
        this.add(this.copyValueItem);
        this.pasteValueItem = module.createMenuItem("testcase.request.parameter.popup.value.paste");
        this.pasteValueItem.setAction(new AbstractAction(this.pasteValueItem.getText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferHandler.getPasteAction().actionPerformed(e);
                ParameterPopupMenu.this.treeModel.nodeChanged(ParameterPopupMenu.this.treePath.getParentPath(), 0, ParameterPopupMenu.this.treePath.getLastPathComponent());
            }
        });
        this.pasteValueItem.setTransferHandler((TransferHandler)this.transferHandler);
        this.add(this.pasteValueItem);
        this.chooseFileItem = module.createMenuItem("testcase.request.parameter.popup.choose.file");
        this.chooseFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File sourceFile = ((BlobParameter)ParameterPopupMenu.this.parameter).getSourceFile();
                File file = FileService.selectFile((File)(sourceFile == null ? ParameterPopupMenu.this.lastDir : sourceFile.getParentFile()), (String)module.getTranslation("testcase.request.parameter.choose.file.dialog.title"), (String)module.getTranslation("testcase.request.parameter.choose.file.dialog.subtitle"));
                if (file != null) {
                    ParameterPopupMenu.this.parameter.setValue((Object)file);
                    ParameterPopupMenu.this.treeModel.nodeChanged(ParameterPopupMenu.this.treePath.getParentPath(), 0, ParameterPopupMenu.this.treePath.getLastPathComponent());
                    ParameterPopupMenu.this.lastDir = file.getParentFile();
                } else if (ParameterPopupMenu.this.lastDir == null && sourceFile != null) {
                    ParameterPopupMenu.this.lastDir = sourceFile.getParentFile();
                }
            }
        });
        this.add(this.chooseFileItem);
        this.deleteItem = module.createMenuItem("testcase.request.parameter.popup.delete.item");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordParameter parent = ((Parameter)ParameterPopupMenu.this.parameter).getParent();
                int index = parent.getIndexOfChild((Object)ParameterPopupMenu.this.parameter);
                parent.removeItem((Parameter)ParameterPopupMenu.this.parameter);
                ParameterPopupMenu.this.treeModel.nodeRemoved(ParameterPopupMenu.this.treePath.getParentPath(), index, (Object)ParameterPopupMenu.this.parameter);
            }
        });
        this.add(this.deleteItem);
    }
}

