/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks.project;

import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.builder.compiler.document.json.xuml.usages.XumlClassUsage;
import ch.e2e.builder.compiler.document.json.xuml.usages.XumlClassesUsages;
import com.scheer.pas.compiler.angular.v13.Angular13Helper;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Extensions;
import com.scheer.pas.compiler.angular.v13.constants.Files;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import com.scheer.pas.compiler.angular.v13.tasks.project.AbstractAngularSourcesTask;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public class AngularLibSourcesTask
extends AbstractAngularSourcesTask {
    public static Boolean select(String id) {
        return id.equals(Files.libSources_file_list);
    }

    public AngularLibSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> sourceSet = super.getBeforeSourceSet();
        sourceSet.add(Files.dataModel__dataModel_classes_usages_xml);
        try {
            this.getSourceManager().getSourceIdsStream().filter(id -> id.endsWith(Extensions._form_json)).forEach(id -> sourceSet.add(id.replace(Extensions._form_json, Extensions._form_xml)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(this.basePath_ + Folders.angularLib_ + Files.angular_json);
        result.add(this.basePath_ + Folders.angularLib_ + Files._gitignore);
        result.add(this.basePath_ + Folders.angularLib_ + Files._npmrc);
        result.add(this.basePath_ + Folders.angularLib_ + Files.package_json);
        result.add(this.basePath_ + Folders.angularLib_ + Files.tsconfig_json);
        result.add(this.basePath_ + Folders.angularLib_ + Files.readme_md);
        String angularProjectName = Angular13Helper.getAngularLibName(this.getProjectName());
        result.add(this.basePath_ + Files.angularLib_projects_PROJECT_src__publicApi_ts(angularProjectName));
        result.add(this.basePath_ + Files.angularLib_projects_PROJECT_src_lib__PROJECT_library_module_ts(angularProjectName));
        String resourcePath = this.basePath_ + Folders.angularLib_projects_PROJECT_(angularProjectName);
        result.add(resourcePath + "ng-package.json");
        result.add(resourcePath + "package.json");
        result.add(resourcePath + "README.md");
        result.add(resourcePath + "tsconfig.lib.json");
        result.add(resourcePath + "tsconfig.lib.prod.json");
        XSLTTransformSource classesUsagesSource = (XSLTTransformSource)this.getSourceManager().getSource(Files.dataModel__dataModel_classes_usages_xml);
        XumlClassesUsages classesUsages = XSLTTransformSource.getJsonDocument(classesUsagesSource, XumlClassesUsages.class);
        try {
            this.getSourceManager().getSourceIdsStream().filter(id -> id.endsWith(Extensions._form_json)).forEach(id -> this.addFormSourcesIfExposed(result, angularProjectName, id.replace(Extensions._form_json, ""), classesUsages));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void addFormSourcesIfExposed(Set<String> result, String projectName, String formPath, XumlClassesUsages classesUsages) {
        String formName = formPath.substring(formPath.lastIndexOf("/") + 1);
        XumlForm xumlForm = ((JsonDocumentSource)this.sourceManager.getSource(Files.form__FORM_form_xml(formName))).getJsonDocument(XumlForm.class);
        if (xumlForm.getLibraryExposed().booleanValue()) {
            result.add(this.basePath_ + Files.angularLib_projects_PROJECT__src_lib_FORMPATH__FORM_form_component_ts(projectName, formPath, formName));
            result.add(this.basePath_ + Files.angularLib_projects_PROJECT__src_lib_FORMPATH__FORM_form_component_html(projectName, formPath, formName));
            AngularLibSourcesTask.addFormInterfaceSources(result, projectName, xumlForm, classesUsages);
        }
    }

    public static void addFormInterfaceSources(Set<String> result, String projectName, XumlForm xumlForm, XumlClassesUsages classesUsages) {
        if (xumlForm.getClassId() != null && xumlForm.getClassId().contains(Extensions._class_json)) {
            LinkedList<String> classToAdd = new LinkedList<String>();
            classToAdd.add(xumlForm.getClassId().substring(0, xumlForm.getClassId().indexOf(Extensions._class_json)));
            while (classToAdd.size() > 0) {
                String classPath = (String)classToAdd.pop();
                if (classPath.equals("") || classPath.contains(Extensions._library_json + "#") || result.contains(Folders.angularLib_projects_PROJECT__src_lib_(projectName) + classPath + Extensions._interface_ts)) continue;
                result.add(AngularVersion.basePath_ + Folders.angularLib_projects_PROJECT__src_lib_(projectName) + classPath + Extensions._interface_ts);
                if (classesUsages.getClassUsages() == null) continue;
                classesUsages.getClassUsages().stream().filter(xumlClassUsages -> xumlClassUsages.getClassPath().equals(classPath)).findFirst().ifPresent(classUsages -> {
                    if (classUsages.getClassUsage() != null) {
                        classToAdd.addAll(classUsages.getClassUsage().stream().map(XumlClassUsage::getClassPath).collect(Collectors.toList()));
                    }
                });
            }
        }
    }
}

