/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.ComponentTemplate;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;

public class ClassifierElement
extends UmlElement {
    public ClassifierElement(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
    }

    public ClassifierElement(String name, BridgeStereotype stereotype, Helpers helpers) {
        this(name, new Comment(stereotype.getCustomization().getElementDescription().getDefault(), helpers), stereotype, helpers);
    }

    public ClassifierElement(BridgeStereotype stereotype, Helpers helpers) {
        this(stereotype.getCustomization().getElementName().getDefault(), new Comment(stereotype.getCustomization().getElementDescription().getDefault(), helpers), stereotype, helpers);
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getElementHelper().createClassReference(this);
    }

    @Override
    public String toDisplayText() {
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return this.getStereotype() == null ? null : this.getStereotype().getCustomization().getIcon();
    }

    public ArrayList<ClassifierElement> findChildrenOfTypes(ArrayList<BridgeStereotype> childTypes) {
        ArrayList<ClassifierElement> children = new ArrayList<ClassifierElement>();
        for (UmlElement child : this.getChildren()) {
            if (childTypes.contains(child.getStereotype())) {
                Boolean useableProperty = (Boolean)child.getStereotype().getCustomization().getProperty("multipleInstancesAllowed");
                if (useableProperty == null || !useableProperty.booleanValue()) continue;
                children.add((ClassifierElement)child);
                continue;
            }
            if (!(child instanceof ClassifierElement)) continue;
            children.addAll(((ClassifierElement)child).findChildrenOfTypes(childTypes));
        }
        return children;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    protected UmlElement createReferenceObject(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        return new ClassifierElement(this.getName(), this.getDescription(), this.getStereotype(), this.getHelpers());
    }

    public ClassifierElement findChildOfType(ComponentTemplate template) {
        ClassifierElement result = null;
        int length = this.getAllChildren().size();
        for (int i = 0; i < length && result == null; ++i) {
            UmlElement child = this.getAllChildren().get(i);
            if (!(child instanceof ClassifierElement) || child.getTemplate() == null || !child.getTemplate().equals(template)) continue;
            result = (ClassifierElement)child;
        }
        return result;
    }
}

