/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.tools;

import ch.e2e.builder.ActivateSaxon;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.compiler.build.BuildProperties;
import ch.e2e.builder.compiler.build.event.BuildProcessStartEvent;
import ch.e2e.builder.compiler.tools.Logging;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.logging.LogWriter;
import ch.e2e.logging.PerformanceLogger;
import ch.e2e.resource.Properties;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.serialize.MessageEmitter;

public class TransformerFactory
implements EventExecuter,
Logging {
    private static TransformerFactory instance;
    private Properties transformerProperties;
    private TransformerLoader transformerLoader;
    private boolean keepScripts;
    private HashMap<String, Templates> transformers = new HashMap();
    private ArrayList<Object> srcFiles = new ArrayList();
    private TransformerFactoryErrorListener errorListener;

    private TransformerFactory(Properties properties) {
        EventController.register((EventExecuter)this, BuildProcessStartEvent.class);
        this.transformerProperties = properties;
        String xmlpath = System.getProperty("ch.e2e.builder.compiler.xmlpath");
        if (xmlpath == null) {
            xmlpath = System.getProperty("ch.e2e.builder.regtest.compiler.xmlpath");
        }
        this.transformerLoader = new TransformerLoader(xmlpath, this.transformerProperties, this.getClass().getClassLoader());
        this.errorListener = new TransformerFactoryErrorListener();
        this.transformerLoader.setErrorListener((ErrorListener)this.errorListener);
        String keepScripts = System.getProperty("ch.e2e.builder.compiler.keep.scripts");
        if (keepScripts == null) {
            keepScripts = System.getProperty("ch.e2e.builder.regtest.compiler.keep.scripts");
        }
        this.keepScripts = keepScripts == null || Boolean.valueOf(keepScripts) != false;
    }

    public static TransformerFactory getInstance() {
        if (instance == null) {
            instance = new TransformerFactory(BuildProperties.getInstance());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer getTransformer(String transformerId, ErrorListener errorListener) throws TransformerLoadException {
        TransformerFactory loader = TransformerFactory.getInstance();
        loader.transformerLoader.setErrorListener(errorListener);
        Transformer transformer = null;
        try {
            transformer = this.getTransformer(transformerId);
        }
        finally {
            loader.transformerLoader.setErrorListener((ErrorListener)loader.errorListener);
        }
        return transformer;
    }

    public Transformer getTransformer(String transformerId) throws TransformerLoadException {
        Transformer transformer;
        Templates templates = TransformerFactory.getInstance().transformers.get(transformerId);
        if (templates == null) {
            long start = PerformanceLogger.start((String)"TransformerFactory.getTransformer", (String)transformerId);
            templates = TransformerFactory.getInstance().transformerLoader.getTemplates(transformerId);
            PerformanceLogger.stop((String)"TransformerFactory.getTransformer", (String)transformerId, (long)start);
            if (templates == null) {
                String message = "Could not load " + transformerId + " transformer.";
                throw new TransformerLoadException(message);
            }
            if (this.keepScripts) {
                TransformerFactory.getInstance().transformers.put(transformerId, templates);
            }
        }
        try {
            transformer = templates.newTransformer();
            transformer.setErrorListener(new TransformerErrorListener());
            if (transformer instanceof TransformerImpl) {
                MessageEmitter emitter = new MessageEmitter();
                emitter.setWriter((Writer)new LogWriter(logger, Level.FINE, Transformer.class.getName(), transformerId));
                ((TransformerImpl)transformer).getUnderlyingController().setMessageEmitter((Receiver)emitter);
            }
        }
        catch (TransformerException e) {
            throw new TransformerLoadException("Could not load the transformer \"" + transformerId + "\"", (Throwable)e);
        }
        return transformer;
    }

    public boolean reload(Object srcFile) {
        boolean result = false;
        if (!TransformerFactory.getInstance().srcFiles.contains(srcFile)) {
            TransformerFactory.getInstance().srcFiles.add(srcFile);
            result = !TransformerFactory.getInstance().keepScripts;
        }
        return result;
    }

    public boolean reloadScripts() {
        return !TransformerFactory.getInstance().keepScripts;
    }

    public String getString(String key) {
        return TransformerFactory.getInstance().transformerProperties.getString(key);
    }

    public void execute(EventObject event) {
        if (!TransformerFactory.getInstance().keepScripts) {
            TransformerFactory.instance.transformers.clear();
            TransformerFactory.instance.srcFiles.clear();
        }
    }

    public void removeTransformer(String transformerId) {
        TransformerFactory.instance.transformers.remove(transformerId);
    }

    static {
        ActivateSaxon.activate();
    }

    private static class TransformerFactoryErrorListener
    implements ErrorListener {
        private TransformerFactoryErrorListener() {
        }

        @Override
        public void error(TransformerException tEx) {
            EventController.fire((EventObject)new SendMessageEvent((Object)this, tEx.getMessageAndLocation(), null, "error", "compiler", "compiler.message.view"));
        }

        @Override
        public void fatalError(TransformerException tEx) {
            EventController.fire((EventObject)new SendMessageEvent((Object)this, tEx.getMessageAndLocation(), null, "fatalerror", "compiler", "compiler.message.view"));
        }

        @Override
        public void warning(TransformerException tEx) {
            EventController.fire((EventObject)new SendMessageEvent((Object)this, tEx.getMessageAndLocation(), null, "warning", "compiler", "compiler.message.view"));
        }
    }

    private static class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void error(TransformerException tEx) {
        }

        @Override
        public void fatalError(TransformerException tEx) {
        }

        @Override
        public void warning(TransformerException tEx) {
        }
    }
}

