/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.serviceRepository.stack;

import ch.e2e.builder.compiler.serviceRepository.stack.DevContainer;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
public class DevContainerRequest
extends DevContainer {
    @JsonProperty
    private List<Integer> ports = new ArrayList<Integer>();
    @JsonProperty
    private List<String> env = new ArrayList<String>();

    public DevContainerRequest(DevContainerType type) {
        this.setType(type);
    }

    @Override
    protected void setType(DevContainerType type) {
        super.setType(type);
        this.env("PORT", String.valueOf(type.getPort()));
        this.port(type.getPort());
    }

    public DevContainerRequest ports(List<Integer> ports) {
        this.ports.addAll(ports);
        return this;
    }

    public DevContainerRequest port(int port) {
        this.ports.add(port);
        return this;
    }

    public DevContainerRequest label(String key, String value) {
        this.putLabel(key, value);
        return this;
    }

    public DevContainerRequest env(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            this.env(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DevContainerRequest env(String key, String value) {
        if (value != null) {
            this.env.removeIf(s -> s.startsWith(key + "="));
            this.env.add(key + "=" + value);
        }
        return this;
    }
}

