/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.arisbpmn;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImportException;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class ArisBPMNImportTransaction
extends ScriptImportTransaction {
    public static final String ARIS_DOCUMENT_SOURCE = "aris.document.source";
    private static final String ARIS_EXPORT_DTD_FILENAME = "ARIS-Export.dtd";
    private static final String ARIS_EXPORT_DTD_PACKAGE = "ch/e2e/builder/compiler/";

    @Override
    protected String getScript() {
        return "arisbpmn2xmi";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTransaction(ImporterData importerData) {
        if (importerData.getDestination() != null) {
            if (importerData.getSource(ARIS_DOCUMENT_SOURCE) instanceof URL) {
                this.transform((URL)importerData.getSource(ARIS_DOCUMENT_SOURCE), importerData);
            } else {
                File srcfile = (File)importerData.getSource(ARIS_DOCUMENT_SOURCE);
                File dtdFile = new File(srcfile.getParentFile(), ARIS_EXPORT_DTD_FILENAME);
                boolean deleteDTD = !dtdFile.exists();
                try {
                    this.copyExportDTD(dtdFile);
                    this.transform(srcfile, importerData);
                }
                catch (IOException ioEx) {
                    XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ioEx));
                }
                finally {
                    if (deleteDTD && dtdFile.exists()) {
                        dtdFile.delete();
                    }
                }
            }
        }
    }

    private void copyExportDTD(File dtdFile) throws IOException {
        if (!dtdFile.exists()) {
            FileUtilities.copyFromClasspath((String)"ch/e2e/builder/compiler/ARIS-Export.dtd", (OutputStream)new FileOutputStream(dtdFile));
        }
    }
}

