/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.document.importer.TestDataModel;
import ch.e2e.builder.compiler.document.importer.TestModelImportSource;
import ch.e2e.builder.compiler.uml.Activity;
import ch.e2e.builder.compiler.uml.ActivityParameter;
import ch.e2e.builder.compiler.uml.ActivityParameterNode;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.CallOperationAction;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class IDLImportTransaction
extends ScriptImportTransaction {
    private Helpers helpers;

    public IDLImportTransaction(Helpers helpers) {
        this.helpers = helpers;
    }

    protected Helpers getHelpers() {
        return this.helpers;
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        ArrayList<IDLImportSource> sources = this.getIDLSources(importerData);
        for (IDLImportSource source : sources) {
            source.readExtensions();
        }
        if (sources != null && sources.size() > 0) {
            this.helpers.getXmiIDFactory().reset();
            HashMap<Element, DeploymentElement> aliases = new HashMap<Element, DeploymentElement>();
            DataModels dataModels = this.createDataModels(sources, aliases);
            this.transformDataModels(dataModels, importerData);
            importerData.addSource(IMPORT_DATA_ALIASES, aliases.values());
        }
    }

    protected void transformDataModels(DataModels dataModels, ImporterData importerData) {
        for (IDLImportSource source : dataModels.importModels.keySet()) {
            if (!source.getImportModel().isCreate()) continue;
            Document model = this.generateDataModelDocument((DataModel)dataModels.importModels.get(source));
            this.printSourceDocument(model, source.getDevelopmentFilename() + ".model");
            source.getImportModel().setModel(model);
        }
        ArrayList<ImportModel> testSources = new ArrayList<ImportModel>();
        for (TestModelImportSource source : dataModels.testModels.keySet()) {
            Document testDocument = this.generateDataModelDocument((DataModel)dataModels.testModels.get(source));
            if (testDocument != null) {
                this.printSourceDocument(testDocument, source.getDevelopmentFilename());
                source.getImportModel().setModel(testDocument);
            }
            testSources.add(source.getImportModel());
        }
        importerData.addSource("test.model.sources", testSources);
    }

    protected abstract ArrayList<IDLImportSource> getIDLSources(ImporterData var1);

    private DataModels createDataModels(ArrayList<IDLImportSource> sources, Map<Element, DeploymentElement> aliases) {
        IDLImportSource.ElementMaps elementMaps = new IDLImportSource.ElementMaps();
        HashMap<IDLImportSource, DataModel> createdModels = new HashMap<IDLImportSource, DataModel>();
        for (IDLImportSource idlSource : sources) {
            DataModel dataModel = idlSource.getDataModel();
            this.setExtensionsParameters(dataModel);
            createdModels.put(idlSource, dataModel);
            elementMaps.putAll(idlSource.getElementMaps());
        }
        for (IDLImportSource idlSource : sources) {
            idlSource.replaceUsingImportedClasses(elementMaps.allClasses);
        }
        DataModels result = new DataModels();
        for (IDLImportSource importSource : createdModels.keySet()) {
            DataModel dataModel = (DataModel)createdModels.get(importSource);
            result.importModels.put(importSource, dataModel);
            if (!importSource.isCreateTestModel()) continue;
            DataModel testModel = this.createTestModel(dataModel, elementMaps);
            if (testModel == null) {
                result.testModels.put(new TestModelImportSource(dataModel.getName() + "Test"), null);
                continue;
            }
            result.testModels.put(new TestModelImportSource(testModel.getName()), testModel);
        }
        this.addHrefs(elementMaps.allElements);
        aliases.putAll(elementMaps.aliases);
        return result;
    }

    private DataModel createTestModel(DataModel importModel, IDLImportSource.ElementMaps elementMaps) {
        this.helpers.getXmiIDFactory().setGlobalPrefix(importModel.getName() + "Test_");
        ArrayList<BridgeClass> backendServices = new ArrayList<BridgeClass>();
        this.findBackendServices(importModel.getModel().getPackages(), importModel, backendServices);
        TestDataModel testModel = new TestDataModel(importModel.getName(), this.helpers);
        testModel.addModule(importModel.getModule());
        if (backendServices.size() > 0) {
            BridgePackage aliasPackage = this.getHelpers().getPackagesFactory().getPackage("Aliases", this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
            aliasPackage.setModule(testModel.getModule());
            for (BridgeClass child : backendServices) {
                DeploymentElement alias = this.findAlias(elementMaps.aliases, child.getBinding());
                BridgeStereotype artifactTemplate = this.getHelpers().getStereotypeFactory().getStereotype("E2EArtifactTemplate");
                if (alias != null && alias.hasStereotype(artifactTemplate)) {
                    ArrayList<BridgeStereotype> aliasTypes = alias.getStereotypes();
                    String name = alias.getName().endsWith("Template") ? alias.getName().substring(0, alias.getName().length() - 8) : alias.getName();
                    DeploymentElement newAlias = new DeploymentElement(name, new Comment(alias.getDescription().getText(), this.helpers), this.helpers);
                    for (BridgeStereotype aliasType : aliasTypes) {
                        if (aliasType.equals(artifactTemplate)) continue;
                        newAlias.addStereotype(aliasType);
                        newAlias.addGeneral(new Generalization(alias, newAlias, this.helpers));
                    }
                    newAlias.setModule(testModel.getModule());
                    newAlias.setOwningPackage(aliasPackage);
                    testModel.addElement(newAlias);
                    testModel.addPackage(aliasPackage);
                    alias = newAlias;
                }
                BridgePackage owningPackage = this.getHelpers().getPackagesFactory().createPackages("Test Services/" + child.getOwningPackage().getName(), testModel.getModel().getOrigin(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
                owningPackage.setModule(testModel.getModule());
                if (child.hasStereotype(this.getHelpers().getStereotypeFactory().getStereotype("RESTInterface"))) {
                    this.addTestRestPortType(testModel, child, owningPackage, alias);
                    continue;
                }
                this.addTestSoapPortType(testModel, child, owningPackage, alias);
            }
        }
        return testModel;
    }

    private void addTestRestPortType(TestDataModel testModel, BridgeClass restInterface, BridgePackage owningPackage, DeploymentElement alias) {
        BridgeClass portType = this.implementRestResource(testModel, restInterface, this.getHelpers().getStereotypeFactory().getStereotype("E2ERESTPortType"), alias);
        portType.setOwningPackage(owningPackage);
        BridgeClass errorClass = new BridgeClass(restInterface.getName() + "RestError", new Comment("", this.helpers), this.getHelpers().getStereotypeFactory().getStereotype("RESTError"), this.helpers);
        errorClass.setOwningPackage(owningPackage);
        testModel.addElement(errorClass);
        portType.setPropertyValueQuietly("errorClass", errorClass);
        testModel.addElement(portType);
    }

    private BridgeClass implementRestResource(TestDataModel testModel, BridgeClass interfaceResource, BridgeStereotype stereotype, DeploymentElement alias) {
        BridgeClass implementation = new BridgeClass(interfaceResource.getName(), interfaceResource.getDescription(), stereotype, this.helpers);
        implementation.setModule(testModel.getModule());
        BridgeStereotype restResource = this.getHelpers().getStereotypeFactory().getStereotype("RESTResource");
        for (UmlElement child : interfaceResource.getAllChildren()) {
            if (child instanceof BridgeOperation) {
                BridgeOperation operation = (BridgeOperation)child;
                BridgeOperation newOperation = operation.createImplementationCopy(testModel.getModule());
                implementation.addOperation(newOperation);
                implementation.addChild(this.createActivity(newOperation, operation, alias, testModel.getModule(), "RESTAdapter"));
                continue;
            }
            if (!(child instanceof BridgeClass) || !child.hasStereotype(restResource)) continue;
            BridgeClass resource = this.implementRestResource(testModel, (BridgeClass)child, restResource, alias);
            resource.setProperties(child.getProperties(restResource), restResource);
            implementation.addChild(resource);
        }
        for (BridgeOperation operation : interfaceResource.getOperations()) {
            BridgeOperation newOperation = operation.createImplementationCopy(testModel.getModule());
            implementation.addOperation(newOperation);
            implementation.addChild(this.createActivity(newOperation, operation, alias, testModel.getModule(), "RESTAdapter"));
        }
        return implementation;
    }

    private void addTestSoapPortType(TestDataModel testModel, BridgeClass soapInterface, BridgePackage owningPackage, DeploymentElement alias) {
        BridgeClass portType = new BridgeClass(soapInterface.getName(), new Comment("", this.helpers), this.getHelpers().getStereotypeFactory().getStereotype("E2ESOAPPortType"), this.helpers);
        portType.setModule(testModel.getModule());
        portType.setOwningPackage(owningPackage);
        for (BridgeOperation operation : soapInterface.getOperations()) {
            BridgeOperation newOperation = operation.createImplementationCopy(testModel.getModule());
            portType.addOperation(newOperation);
            String adapter = (String)operation.getParent().getStereotype().getCustomization().getProperty("adapter");
            if (adapter == null) {
                adapter = "SOAPAdapter";
            }
            portType.addChild(this.createActivity(newOperation, operation, alias, testModel.getModule(), adapter));
        }
        testModel.addElement(portType);
    }

    private DeploymentElement findAlias(HashMap<Element, DeploymentElement> aliases, String binding) {
        DeploymentElement alias = null;
        for (DeploymentElement child : aliases.values()) {
            if (child.getBinding() == null || !child.getBinding().equals(binding)) continue;
            alias = child;
        }
        return alias;
    }

    private Activity createActivity(BridgeOperation operation, BridgeOperation callOperation, DeploymentElement alias, Module module, String adapter) {
        Activity activity = new Activity(operation, this.helpers);
        activity.setModule(module);
        operation.setMethod(activity);
        CallOperationAction action = new CallOperationAction(callOperation, module, this.helpers);
        action.setModule(module);
        action.setStereotype(this.getHelpers().getStereotypeFactory().getStereotype(adapter));
        action.setPropertyValueQuietly("alias", alias);
        activity.appendNode(action);
        for (UmlElement child : callOperation.getParameters()) {
            BridgeParameter parameter = (BridgeParameter)child;
            ActivityParameter activityParameter = new ActivityParameter(parameter, this.helpers);
            activityParameter.setModule(module);
            activity.addChild(activityParameter);
            ActivityParameterNode parameterNode = new ActivityParameterNode(activityParameter, this.helpers);
            parameterNode.setModule(module);
            activity.addChild(parameterNode);
            activity.addParameter(parameterNode, action, parameter.getDirection());
        }
        return activity;
    }

    private void findBackendServices(Collection<ModelPackage> packages, DataModel importModel, ArrayList<BridgeClass> backendServices) {
        for (ModelPackage modelPackage : packages) {
            for (UmlElement child : modelPackage.getUmlElements()) {
                if (child.getStereotype() == null || !child.getStereotype().isBackendInterfaceType() || !importModel.checkModule(child.getModule())) continue;
                backendServices.add((BridgeClass)child);
            }
            this.findBackendServices(modelPackage.getPackages(), importModel, backendServices);
        }
    }

    private void addHrefs(HashMap<Object, UmlElement> allElements) {
        for (Object element : allElements.keySet()) {
            UmlElement umlElement = allElements.get(element);
            if (!(element instanceof Element)) continue;
            ((Element)element).setAttribute("href", umlElement.getModule().getName() + "#" + umlElement.getXmiID());
        }
    }

    private Document generateDataModelDocument(DataModel dataModel) {
        this.helpers.getXmiIDFactory().setGlobalPrefix(dataModel.getName() + '_');
        return dataModel.createDocument();
    }

    protected class DataModels {
        private HashMap<IDLImportSource, DataModel> importModels = new HashMap();
        private HashMap<TestModelImportSource, DataModel> testModels = new HashMap();
    }
}

