/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.w3c.dom.Element;

public class RepositoryResource
extends DescriptorElement {
    private String targetFolder;
    private String templatesFolder;
    private String name;
    private ArrayList<String> stereotypes;
    private boolean flatten;
    private DescriptorElement parent;

    public RepositoryResource(Element xmlElement, DescriptorElement parent) {
        super(xmlElement);
        this.parent = parent;
        this.name = xmlElement.getAttribute("name");
        this.targetFolder = xmlElement.hasAttribute("targetFolder") ? xmlElement.getAttribute("targetFolder") : null;
        this.setTargetFolder(this.targetFolder);
        this.templatesFolder = xmlElement.hasAttribute("templatesFolder") ? xmlElement.getAttribute("templatesFolder") : null;
        try {
            this.stereotypes = new ArrayList<String>(Arrays.asList(StringTools.createStringArray((String)xmlElement.getAttribute("stereotypes"))));
        }
        catch (ParseException e) {
            this.stereotypes = new ArrayList();
        }
        this.flatten = DomUtilities.getBoolean((Element)xmlElement, (String)"flatten", (boolean)false);
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.getParent().getUmlDocument();
    }

    public DescriptorElement getParent() {
        return this.parent;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public File getTargetFile(File repositoryFolder) {
        File targetFolder = new File(repositoryFolder, this.targetFolder);
        String name = this.name;
        File targetFile = new File(targetFolder, name);
        if (this.flatten) {
            name = targetFile.getName();
            targetFile = new File(targetFolder, name);
        }
        return targetFile;
    }

    void setTargetFolder(String targetFolder) {
        if (targetFolder != null && (targetFolder = targetFolder.replace('\\', '/')).length() > 0 && !targetFolder.endsWith("/")) {
            targetFolder = targetFolder + '/';
        }
        this.targetFolder = targetFolder;
    }

    void setTemplatesFolder(String templatesFolder) {
        this.templatesFolder = templatesFolder;
    }

    public Set<String> applyToTargetFiles(Consumer<Map.Entry<String, InputStream>> consumer, AbstractErrorHandler errorHandler) throws IOException {
        String name = this.name;
        File file = this.getTemplateFile();
        if (this.flatten) {
            name = file.getName();
        }
        HashSet<String> targetFiles = new HashSet<String>();
        if (file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                consumer.accept(new AbstractMap.SimpleEntry<String, FileInputStream>(this.targetFolder + name, inputStream));
                targetFiles.add(this.targetFolder + name);
            }
        } else {
            targetFiles.add(this.targetFolder + name);
        }
        return targetFiles;
    }

    public File getTemplateFile() {
        File projectHome = this.getUmlDocument().getSettings().getProjectFolder();
        File templatesFolder = new File(projectHome, this.templatesFolder);
        return this.createTemplateFile(templatesFolder);
    }

    protected File createTemplateFile(File templatesFolder) {
        return new File(templatesFolder, this.name);
    }

    protected String getTemplatesFolder() {
        return this.templatesFolder;
    }

    protected ArrayList<String> getStereotypes() {
        return this.stereotypes;
    }

    boolean isFlatten() {
        return this.flatten;
    }
}

