/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Key;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Keys
extends RichElement {
    public static final String ELEMENT_NAME = "keys";
    private Map<String, Key> keys = new TreeMap<String, Key>();

    public Keys() {
    }

    public Keys(Element tabfileElement) {
        super(tabfileElement);
        Iterator it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("key"));
        while (it.hasNext()) {
            Key incoming = new Key((Element)it.next());
            this.keys.putIfAbsent(incoming.getAttributeValue("key"), incoming);
        }
    }

    public void merge(Keys other) {
        if (other != null) {
            this.keys.putAll(other.keys);
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.keys.values());
    }

    public JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Key> e : this.keys.entrySet()) {
            String nilAttr = e.getValue().getAttributeValue("nil");
            if (nilAttr == null || !nilAttr.equals("true")) {
                builder.add(e.getKey(), e.getValue().buildJson());
                continue;
            }
            builder.add(e.getKey(), JsonValue.NULL);
        }
        return builder;
    }
}

