/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.types.LibraryVersionChecker;
import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.TabfileContainer;
import ch.e2e.builder.compiler.build.types.TabfileTools;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.builder.compiler.error.DefaultCompilerWarning;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TabfileMergeContainer
extends TabfileContainer {
    public static final long serialVersionUID = 1L;
    private static final String REVISIONS_TABFILE = "tabfiles/revisions.tab";
    protected HashMap<String, XmlTabfile> tabfilesMap = new HashMap();
    private boolean library;
    private AbstractErrorHandler errorHandler;

    public TabfileMergeContainer(File file, boolean library) {
        super(file);
        this.library = library;
    }

    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(){};
        }
        return this.errorHandler;
    }

    public void appendTables(Document resultDoc, Element configurationElement, CompilableObject compilableObject) {
        NodeList tableList = resultDoc.getDocumentElement().getChildNodes();
        if (tableList != null) {
            int length = tableList.getLength();
            for (int i = 0; i < length; ++i) {
                if (!(tableList.item(i) instanceof Element)) continue;
                Element tableElement = (Element)tableList.item(i);
                String name = tableElement.getAttribute("name");
                if (name.length() == 0) {
                    if (Boolean.getBoolean("ch.e2e.builder.development")) {
                        throw new BuildException(this.getClass().getSimpleName() + ": Target tabfile not specified for table element '" + tableElement.getNodeName() + "'.");
                    }
                    HashMap<String, String> parameter = new HashMap<String, String>();
                    parameter.put("name", tableElement.getNodeName());
                    DefaultCompilerWarning warning = new DefaultCompilerWarning("warning.merging.tabfiles.unknown.target", parameter);
                    this.getErrorHandler().warning((BuilderWarning)warning);
                    continue;
                }
                XmlTabfile tabfile = this.getTabfile(name, tableElement.getAttribute("filename"), tableElement.getNodeName());
                tabfile.appendTable(tableElement, configurationElement, compilableObject, null);
            }
        }
    }

    private void appendLibraryEntry(ZipFile repository, ZipEntry entry, Element configurationElement, CompilableObject compilableObject, LibraryService library) {
        try {
            Document tabfileDocument = DomUtilities.parse((InputStream)repository.getInputStream(entry), (boolean)false, (boolean)false, (boolean)false);
            this.appendLibraryDocument(entry.getName(), tabfileDocument, configurationElement, compilableObject, library);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "", e);
            throw new BuildException("Exception merging tabfiles from module '" + library + "' and tabfile '" + entry.getName() + "'.", e);
        }
    }

    public void appendLibrary(LibraryService library, Element configurationElement, CompilableObject compilableObject) throws BuildException {
        block17: {
            if (library.getRepository().exists()) {
                try (ZipFile repository = new ZipFile(library.getRepository());){
                    Enumeration<? extends ZipEntry> tabfiles = repository.entries();
                    while (tabfiles.hasMoreElements()) {
                        ZipEntry next = tabfiles.nextElement();
                        if (next.isDirectory() || !next.getName().startsWith("templates/") && !next.getName().startsWith("tabfiles/") && !next.getName().startsWith("documentation/")) continue;
                        this.appendLibraryEntry(repository, next, configurationElement, compilableObject, library);
                    }
                    break block17;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "", e);
                    throw new BuildException("Exception merging tabfiles from module '" + library + "'.", e);
                }
            }
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("library.name", library.getName());
            DefaultCompilerError error = new DefaultCompilerError("error.merging.tabfiles.imported.library.not.found", parameter);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
    }

    public void appendLibraryVersion(LibraryService library, Element configurationElement, CompilableObject compilableObject) {
        block16: {
            if (library.getRepository().exists()) {
                try (ZipFile repository = new ZipFile(library.getRepository());){
                    ZipEntry revisionsEntry = repository.getEntry(REVISIONS_TABFILE);
                    this.appendLibraryEntry(repository, revisionsEntry, configurationElement, compilableObject, library);
                    break block16;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "", e);
                    throw new BuildException("Exception merging tabfiles from module '" + library + "'.", e);
                }
            }
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("library.name", library.getName());
            DefaultCompilerError error = new DefaultCompilerError("error.merging.tabfiles.imported.library.not.found", parameter);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTabfiles(boolean indent) throws Exception {
        SubstitutionsTabfile substitutions = (SubstitutionsTabfile)this.tabfilesMap.get("substitutions");
        this.doMergePostProcess(substitutions);
        if (this.tabfilesMap.size() > 0) {
            if (!this.getParentFile().exists()) {
                this.getParentFile().mkdirs();
            }
            FileOutputStream fileOut = null;
            try {
                fileOut = new FileOutputStream(this);
                this.writeTabfiles(substitutions, fileOut, indent);
            }
            finally {
                try {
                    if (fileOut != null) {
                        fileOut.flush();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOut != null) {
                        fileOut.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean checkLibraryVersions() throws XPathExpressionException {
        XmlTabfile revisions = this.tabfilesMap.get("revisions");
        if (revisions == null) {
            return true;
        }
        LibraryVersionChecker versionChecker = new LibraryVersionChecker(revisions.getTabfileDocument());
        boolean result = versionChecker.doCheck();
        versionChecker.getErrorHandler().addTo(this.getErrorHandler());
        return result;
    }

    public XmlTabfile getTabfile(String name, String filename, String rootElementName) {
        name = name.replace('\\', '/');
        XmlTabfile tabfile = this.tabfilesMap.get(filename.length() == 0 ? name : filename);
        if (tabfile == null) {
            String tabfileName = CompilerConstants.createClassName(name);
            String classname = this.getClass().getPackage().getName() + '.' + tabfileName + "Tabfile";
            try {
                Class<?> clazz = Class.forName(classname);
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class);
                tabfile = (XmlTabfile)constructor.newInstance(rootElementName, name, filename);
                tabfile.setOriginalName(name);
            }
            catch (Exception ex) {
                tabfile = new XmlTabfile(rootElementName, name, filename);
            }
            String key = tabfile.getKey(this.library);
            if (this.tabfilesMap.containsKey(key)) {
                tabfile = this.tabfilesMap.get(key);
            } else {
                this.tabfilesMap.put(key, tabfile);
            }
        }
        return tabfile;
    }

    private void appendLibraryDocument(String name, Document tabfileDocument, Element configurationElement, CompilableObject compilableObject, LibraryService library) {
        if (name.startsWith("templates/")) {
            name = name.substring("templates/".length());
        } else if (name.startsWith("tabfiles/")) {
            name = name.substring("tabfiles/".length());
        } else if (name.startsWith("documentation/")) {
            name = name.substring("documentation/".length());
        }
        if (name != null) {
            name = name.substring(0, name.lastIndexOf(46));
            Element tabfileElement = tabfileDocument.getDocumentElement();
            if (DomUtilities.getBoolean((Element)tabfileElement, (String)"multiTabfileDocument", (boolean)false)) {
                String rootElementName = tabfileElement.getAttribute("rootElementName");
                NodeList tables = tabfileElement.getElementsByTagName(rootElementName);
                int length = tables.getLength();
                for (int i = 0; i < length; ++i) {
                    this.addTabfileTable(name, (Element)tables.item(i), configurationElement, compilableObject, library);
                }
            } else {
                this.addTabfileTable(name, tabfileElement, configurationElement, compilableObject, library);
            }
        }
    }

    private void addTabfileTable(String name, Element tabfileElement, Element configurationElement, CompilableObject compilableObject, LibraryService library) {
        String rootElementName = tabfileElement.getNodeName();
        XmlTabfile tabfile = this.getTabfile(name, tabfileElement.getAttribute("filename"), rootElementName);
        tabfile.appendTable(tabfileElement, configurationElement, compilableObject, library);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTabfiles(SubstitutionsTabfile substitutions, FileOutputStream fileOut, boolean indent) throws IOException {
        Map<Object, Object> templates = substitutions == null ? new HashMap() : substitutions.getTemplates();
        this.tabfilesMap.remove("substitutions");
        XmlTabfile modulesTabfile = this.tabfilesMap.remove("modules");
        XmlTabfile featuresTabfile = this.tabfilesMap.remove("features");
        ZipOutputStream zipOut = new ZipOutputStream(fileOut);
        Iterator<String> files = this.tabfilesMap.keySet().iterator();
        ArrayList<String> directories = new ArrayList<String>();
        this.checkDirectory("tabfiles/", directories, zipOut);
        this.checkDirectory("templates/", directories, zipOut);
        try {
            while (files.hasNext() && !this.getErrorHandler().hasFatalErrors()) {
                String name = files.next();
                XmlTabfile tabfile = this.tabfilesMap.get(name);
                String fullName = tabfile.getFullName(this.library);
                this.checkDirectory(fullName, directories, zipOut);
                TemplatedFile templatedFile = (TemplatedFile)templates.get(name);
                if (templatedFile != null) {
                    fullName = tabfile.getFullTemplateName(this.library);
                    this.checkDirectory(fullName, directories, zipOut);
                }
                featuresTabfile.getRuntimeFeatures().addAll(tabfile.getRuntimeFeatures());
                this.writeTabfile(tabfile, fullName, zipOut, indent);
            }
            if (!this.getErrorHandler().hasFatalErrors()) {
                if (this.library) {
                    this.writeTabfile(substitutions, "tabfiles/substitutions.tab", zipOut, indent);
                    this.writeTabfile(modulesTabfile, "tabfiles/modules.tab", zipOut, indent);
                } else {
                    this.writeTabfile(substitutions, "substitutions.xml", zipOut, indent);
                    this.writeTabfile(modulesTabfile, "modules.xml", zipOut, indent);
                }
            }
            if (!this.getErrorHandler().hasFatalErrors()) {
                this.writeTabfile(featuresTabfile, featuresTabfile.getFullName(this.library), zipOut, indent);
            }
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "writeTabfiles", e);
        }
        finally {
            zipOut.closeEntry();
        }
        zipOut.close();
    }

    private void checkDirectory(String name, ArrayList<String> directories, ZipOutputStream zipOut) throws IOException {
        String directory;
        int index = name.lastIndexOf(47);
        if (index != -1 && !directories.contains(directory = name.substring(0, index + 1))) {
            TabfileTools.getInstance().addDirectory(directory, directories, zipOut);
        }
    }

    private void writeTabfile(XmlTabfile tabfile, String fullName, ZipOutputStream zipOut, boolean indent) {
        if (tabfile != null && tabfile.getTabfileDocument() != null) {
            try {
                tabfile.beforeSerialize(zipOut, fullName, this.library);
                if (!tabfile.getErrorHandler().hasFatalErrors()) {
                    tabfile.serialize(zipOut, indent, this.library);
                }
            }
            catch (Exception e) {
                Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logging.logger.throwing(this.getClass().getName(), "writeTabfile", e);
                this.getErrorHandler().error((Throwable)e);
            }
            tabfile.getErrorHandler().addTo(this.getErrorHandler());
        }
    }

    private void doMergePostProcess(SubstitutionsTabfile substitutions) throws XPathExpressionException {
        for (XmlTabfile tabfile : this.tabfilesMap.values()) {
            tabfile.doMergePostProcess(substitutions, this.library);
        }
    }
}

