/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.handler.Selector;
import ch.e2e.builder.compiler.build.tasks.handler.TaskCreator;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class SimpleTaskFactory
extends TaskFactory {
    Selector selector;
    TaskCreator taskCreator;
    Double priority;

    public SimpleTaskFactory(Selector selector, TaskCreator taskCreator) {
        this(selector, taskCreator, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleTaskFactory(Selector selector, TaskCreator taskCreator, Double priority) {
        this.selector = selector;
        this.taskCreator = taskCreator;
        this.priority = priority;
    }

    public SimpleTaskFactory(Selector selector, Class<? extends CacheAbleTask> taskClass) {
        this(selector, taskClass, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleTaskFactory(Selector selector, Class<? extends CacheAbleTask> taskClass, Double priority) {
        this.priority = priority;
        this.selector = selector;
        this.taskCreator = this.getCreator(taskClass);
    }

    public SimpleTaskFactory(Class<? extends CacheAbleTask> taskClass) {
        this(taskClass, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleTaskFactory(Class<? extends CacheAbleTask> taskClass, Double priority) {
        this.priority = priority;
        this.selector = this.getSelector(taskClass);
        this.taskCreator = this.getCreator(taskClass);
    }

    protected TaskCreator getCreator(Class<? extends CacheAbleTask> taskClass) {
        return (sourceManager, id) -> {
            try {
                Constructor<? extends CacheAbleTask> constructor = SimpleTaskFactory.getConstructor(taskClass, SourceManager.class, String.class);
                if (constructor != null) {
                    return constructor.newInstance(sourceManager, id);
                }
                constructor = SimpleTaskFactory.getConstructor(taskClass, String.class, SourceManager.class);
                if (constructor != null) {
                    return constructor.newInstance(id, sourceManager);
                }
                constructor = SimpleTaskFactory.getConstructor(taskClass, SourceManager.class);
                if (constructor != null) {
                    return constructor.newInstance(sourceManager);
                }
                constructor = SimpleTaskFactory.getConstructor(taskClass, String.class);
                if (constructor != null) {
                    return constructor.newInstance(id);
                }
                constructor = SimpleTaskFactory.getConstructor(taskClass, new Class[0]);
                if (constructor != null) {
                    return constructor.newInstance(new Object[0]);
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            return null;
        };
    }

    protected Selector getSelector(Class<? extends CacheAbleTask> taskClass) {
        return id -> {
            try {
                Method select = taskClass.getMethod("select", String.class);
                if (!Modifier.isStatic(select.getModifiers())) {
                    Logging.logger.warning("'select' method is not static on class " + taskClass.getCanonicalName());
                    return false;
                }
                if (Boolean.class.isAssignableFrom(select.getReturnType())) {
                    return (Boolean)select.invoke(null, id);
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            return false;
        };
    }

    protected static Constructor<? extends CacheAbleTask> getConstructor(Class<? extends CacheAbleTask> taskClass, Class<?> ... parameterTypes) {
        try {
            return taskClass.getConstructor(parameterTypes);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    @Override
    public Boolean matchId(String id) {
        return this.selector.select(id);
    }

    @Override
    public CacheAbleTask createTask(String id, SourceManager sourceManager) {
        return this.taskCreator.create(sourceManager, id);
    }

    @Override
    public Double getPriority() {
        return this.priority;
    }
}

