/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.rest;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.handler.TaskCreator;
import ch.e2e.builder.compiler.build.tasks.source.SimpleTaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class RestTask
extends CacheAbleTask {
    private static final MediaType[] ACCEPTED_MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_JSON_TYPE};
    private final Client client;

    public RestTask(SourceManager sourceManager, String id, Client client) {
        super(sourceManager, id);
        this.client = client;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.executeRestOperation(dependencyLevel);
    }

    protected String getMethod() {
        return "POST";
    }

    protected void executeRestOperation(int dependencyLevel) {
        WebTarget webTarget = this.client.target(this.getBaseUrl()).path(this.getActionPath());
        this.getQueryParams().forEach((arg_0, arg_1) -> ((WebTarget)webTarget).queryParam(arg_0, arg_1));
        try (Response response = webTarget.request(this.getAcceptedMediaTypes()).build(this.getMethod(), this.getEntity()).invoke();){
            this.handleResponse(response);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected abstract String getBaseUrl();

    protected abstract String getActionPath();

    protected Map<String, Object[]> getQueryParams() {
        return Collections.emptyMap();
    }

    protected MediaType[] getAcceptedMediaTypes() {
        return ACCEPTED_MEDIA_TYPES;
    }

    protected abstract Entity<?> getEntity();

    protected abstract void handleResponse(Response var1) throws Exception;

    protected void handleError(Exception e) {
        this.getErrorHandler().error((Throwable)e);
    }

    public static class Factory
    extends SimpleTaskFactory {
        private final Client client;

        public Factory(Class<? extends CacheAbleTask> taskClass, Client client, Double priority) {
            super(taskClass, priority);
            this.client = client;
        }

        @Override
        protected TaskCreator getCreator(Class<? extends CacheAbleTask> taskClass) {
            return (sourceManager, id) -> {
                try {
                    Constructor<? extends CacheAbleTask> constructor = Factory.getConstructor(taskClass, SourceManager.class, String.class, Client.class);
                    if (constructor != null) {
                        return constructor.newInstance(sourceManager, id, this.client);
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                return null;
            };
        }
    }
}

