/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.control;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.control.TaskInfo;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;

public class TraceCompileControl
extends CompileControl {
    private final Path logFile;

    public TraceCompileControl(Path logFile) {
        this.logFile = logFile;
    }

    @Override
    public void onTaskUpToDate(TaskInfo taskInfo, Integer dependencyLevel) {
        this.trace(taskInfo, "UP TO DATE", dependencyLevel);
    }

    @Override
    public void onTaskException(TaskInfo taskInfo, Integer dependencyLevel) {
        this.trace(taskInfo, "EXECUTED with Exception - " + (new Date().getTime() - taskInfo.getStartTime().getTime()), dependencyLevel);
    }

    @Override
    public void onTaskAfterExecute(TaskInfo taskInfo, Integer dependencyLevel) {
        AbstractErrorHandler errorHandler = taskInfo.getErrorHandler();
        if (errorHandler.getErrorCount() > 0) {
            this.trace(taskInfo, "EXECUTED with " + errorHandler.getErrorCount() + " errors - " + taskInfo.getDuration(), dependencyLevel);
        } else {
            this.trace(taskInfo, "EXECUTED - " + taskInfo.getDuration(), dependencyLevel);
        }
        super.onTaskAfterExecute(taskInfo, dependencyLevel);
    }

    private void trace(TaskInfo taskInfo, String message, int dependencyLevel) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(new Date().toString() + ": ");
        for (int i = 0; i < dependencyLevel; ++i) {
            logMessage.append("--");
        }
        logMessage.append(" ").append(taskInfo.getId()).append(" - ").append(message).append("\n");
        try {
            Files.createDirectories(this.logFile.getParent(), new FileAttribute[0]);
            if (Files.notExists(this.logFile, new LinkOption[0])) {
                Files.createFile(this.logFile, new FileAttribute[0]);
            }
            Files.write(this.logFile, logMessage.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

