/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.compiler.Properties;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.cache.ResultCache;
import ch.e2e.builder.compiler.build.tasks.cache.SourceCache;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.error.TaskErrorHandler;
import ch.e2e.builder.compiler.build.tasks.error.TaskFatalError;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

public abstract class CacheAbleTask
extends Task
implements FileSource {
    private final String id;
    protected final SourceManager sourceManager;
    private AbstractErrorHandler errorHandler;
    private final String compilerVersion;
    private String hash = null;
    private Map<String, Source> beforeSourceMap;
    private Map<String, Source> sourceMap = new HashMap<String, Source>();
    private ResultCache resultCache;
    private Map<String, Source> sourcesToCheckMap;

    public CacheAbleTask(SourceManager sourceManager, String id) {
        super(sourceManager.getCompileControls());
        this.sourceManager = sourceManager;
        this.compilerVersion = this.getCompilerVersion();
        this.id = id;
        this.getTaskInfo().setId(this.getName());
    }

    @Override
    public String getName() {
        return super.getName() + ":" + this.getId();
    }

    protected SourceManager getSourceManager() {
        return this.sourceManager;
    }

    protected String getCompilerVersion() {
        return new Properties().getProperty("version");
    }

    public final String getId() {
        return this.id;
    }

    public File getDestinationFile() {
        return new File(this.sourceManager.getWorkFolder(), this.getId());
    }

    protected String getDestinationFileName() {
        return this.getDestinationFile().getName();
    }

    protected String getDestinationFileExtension() {
        return "";
    }

    protected String getDestinationFileNameWithoutExtension() {
        String name = this.getDestinationFileName();
        return name.substring(0, name.length() - this.getDestinationFileExtension().length());
    }

    protected String getDestinationFilePathWithoutExtension() {
        String path = this.getId();
        return path.substring(0, path.length() - this.getDestinationFileExtension().length());
    }

    protected void writeToDestinationFile(File sourceFile) throws IOException {
        File f = sourceFile.isAbsolute() ? sourceFile : new File(this.sourceManager.getWorkFolder(), sourceFile.getPath());
        try (FileInputStream input = new FileInputStream(f);){
            this.writeToDestinationFile(input);
        }
    }

    protected void writeToDestinationFile(InputStream inputStream) throws IOException {
        Path destinationFile = this.getDestinationFile().toPath();
        Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
        Files.copy(inputStream, destinationFile, StandardCopyOption.REPLACE_EXISTING);
    }

    protected String getDestinationFolder() {
        return this.getId().substring(0, this.getId().lastIndexOf(Folders.SEPARATOR));
    }

    @Override
    public File getFile() {
        return this.getDestinationFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.getFile().toPath(), new OpenOption[0]);
    }

    protected String getErrorHash() {
        return this.getHash(this.getErrorHandler().getLogfile().toPath());
    }

    protected String getOutputHash() {
        return this.getHash(this.getDestinationFile().toPath());
    }

    protected String getHash(Path id) {
        try {
            if (Files.isSymbolicLink(id)) {
                return "symLink";
            }
            byte[] b = Files.readAllBytes(id);
            byte[] hashB = MessageDigest.getInstance("MD5").digest(b);
            return DatatypeConverter.printHexBinary((byte[])hashB);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getHash() {
        if (this.hash == null) {
            String errorHash;
            this.hash = this.getOutputHash();
            if (this.hash == null) {
                this.hash = "";
            }
            if ((errorHash = this.getErrorHash()) != null && !errorHash.isEmpty()) {
                this.hash = this.hash + "-" + errorHash;
            }
        }
        return this.hash;
    }

    @Override
    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new TaskErrorHandler(this.getId(), new File(this.getDestinationFile().getParentFile(), this.getDestinationFile().getName() + ".errors")){};
        }
        return this.errorHandler;
    }

    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        this.sourceManager.getTaskSourceSetFactoryStream(this.id).forEach(f -> result.addAll(f.getBeforeSourceSet(this.getSourceManager())));
        return result;
    }

    private Map<String, Source> getBeforeSourceMap() {
        if (this.beforeSourceMap == null) {
            this.beforeSourceMap = new HashMap<String, Source>();
            for (String id : this.getBeforeSourceSet()) {
                Source source = this.sourceManager.getSource(id);
                if (source == null) continue;
                this.beforeSourceMap.put(id, source);
            }
        }
        return new HashMap<String, Source>(this.beforeSourceMap);
    }

    protected Set<String> getSourceSet() {
        return this.sourceManager.getTaskSourceSetFactoryStream(this.id).flatMap(f -> f.getSourceSet(this.getSourceManager()).stream()).collect(Collectors.toSet());
    }

    private Map<String, Source> getSourceMap() {
        return new HashMap<String, Source>(this.sourceMap);
    }

    protected final Source getSource(String id) {
        Source source = this.getSourceMap().get(id);
        if (source == null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", id);
            this.getErrorHandler().fatalError((BuilderFatalError)new TaskFatalError("FTASK0001", parameters));
        }
        return source;
    }

    protected final <T extends Source> T getSource(String id, Class<T> type) {
        return (T)this.getSource(id);
    }

    @Override
    protected void afterExecute() {
        this.hash = null;
        this.saveResultCache();
    }

    @Override
    public boolean isUpToDate() {
        String hash;
        ResultCache resultCache = this.getResultCache();
        if (!resultCache.compilerVersion.equals(this.compilerVersion)) {
            return false;
        }
        if (this.getSourceMap().size() != resultCache.sourceHashsMap.size()) {
            return false;
        }
        if (!(this.getDestinationFile().exists() && resultCache.lastModified != 0L && this.getDestinationFile().lastModified() == resultCache.lastModified || (hash = this.getHash()) != null && !hash.isEmpty() && resultCache.hash != null && !resultCache.hash.isEmpty() && resultCache.hash.equals(hash))) {
            return false;
        }
        for (Map.Entry<String, Source> source : this.getSourceMap().entrySet()) {
            String sourceHash;
            SourceCache sourceCache = resultCache.sourceHashsMap.get(source.getKey());
            if (source.getValue() == null || sourceCache == null) {
                return false;
            }
            if (source.getValue() instanceof FileSource && sourceCache.lastModified != 0L && ((FileSource)source.getValue()).getFile().lastModified() == sourceCache.lastModified || (sourceHash = source.getValue().getHash()) != null && !sourceHash.isEmpty() && sourceCache.hash != null && !sourceCache.hash.isEmpty() && sourceHash.equals(sourceCache.hash)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected AbstractErrorHandler executeDependsOnTasks(int dependencyLevel) {
        AbstractErrorHandler errorHandler = super.executeDependsOnTasks(dependencyLevel);
        try {
            Task task;
            for (Source source : this.getBeforeSourceMap().values()) {
                if (!(source instanceof Task)) continue;
                task = (Task)((Object)source);
                if (!task.isExecuted()) {
                    task.execute(dependencyLevel + 1);
                }
                task.getErrorHandler().addTo(errorHandler);
            }
            if (errorHandler.hasErrors()) {
                return errorHandler;
            }
            this.sourceMap = this.getBeforeSourceMap();
            for (String id : this.getSourceSet()) {
                Source source = this.sourceManager.getSource(id);
                this.sourceMap.put(id, source);
                if (source != null) continue;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("id", id);
                errorHandler.fatalError((BuilderFatalError)new TaskFatalError("FTASK0001", parameters));
            }
            for (Source source : this.getSourcesToCheckMap().values()) {
                if (!(source instanceof Task)) continue;
                task = (Task)((Object)source);
                if (!task.isExecuted()) {
                    task.execute(dependencyLevel + 1);
                }
                task.getErrorHandler().addTo(errorHandler);
            }
        }
        catch (Exception e) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", this.id);
            errorHandler.error((Throwable)e);
            errorHandler.fatalError((BuilderFatalError)new TaskFatalError("FTASK0002", parameters));
        }
        return errorHandler;
    }

    private File getResultCacheFile() {
        return new File(this.sourceManager.getWorkFolder(), this.getId() + Extensions._hash);
    }

    private ResultCache getResultCache() {
        if (this.resultCache == null) {
            try {
                this.resultCache = JaxbUtils.unmarshalXml(this.getResultCacheFile(), ResultCache.class);
            }
            catch (Exception e) {
                this.resultCache = new ResultCache();
            }
        }
        return this.resultCache;
    }

    protected SourceCache createSourceCache(Source source) {
        SourceCache sourceCache = new SourceCache();
        sourceCache.hash = source.getHash();
        if (source instanceof FileSource) {
            sourceCache.lastModified = ((FileSource)source).getFile().lastModified();
        }
        return sourceCache;
    }

    protected void addLastModified(ResultCache resultCache) {
        if (this.getDestinationFile().exists()) {
            resultCache.lastModified = this.getDestinationFile().lastModified();
        }
    }

    protected void saveResultCache() {
        ResultCache resultCache = new ResultCache();
        resultCache.compilerVersion = this.compilerVersion;
        resultCache.hash = this.getHash();
        this.addLastModified(resultCache);
        ArrayList<Map.Entry<String, Source>> beforeSources = new ArrayList<Map.Entry<String, Source>>(this.getBeforeSourceMap().entrySet());
        beforeSources.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : beforeSources) {
            if (entry.getValue() == null) continue;
            resultCache.sourceHashsMap.put((String)entry.getKey(), this.createSourceCache((Source)entry.getValue()));
        }
        ArrayList<Map.Entry<String, Source>> sources = new ArrayList<Map.Entry<String, Source>>(this.getSourceMap().entrySet());
        sources.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : sources) {
            if (entry.getValue() == null) continue;
            resultCache.sourceHashsMap.put((String)entry.getKey(), this.createSourceCache((Source)entry.getValue()));
        }
        JaxbUtils.marshalXml((Object)resultCache, this.getResultCacheFile());
    }

    @Override
    protected void propagateErrors() {
        this.getErrorHandler().serialize(false);
    }

    @Override
    public String getTaskSourceName() {
        return "";
    }

    protected Set<String> getSourcesToCheck() {
        HashSet<String> result = new HashSet<String>();
        this.sourceManager.getTaskSourceSetFactoryStream(this.id).forEach(f -> result.addAll(f.getSourcesToCheck(this.getSourceManager())));
        return result;
    }

    private Map<String, Source> getSourcesToCheckMap() {
        if (this.sourcesToCheckMap == null) {
            this.sourcesToCheckMap = this.getSourceMap();
            for (String id : this.getSourcesToCheck()) {
                Source source = this.sourceManager.getSource(id);
                if (source == null) continue;
                this.sourcesToCheckMap.put(id, source);
            }
        }
        return new HashMap<String, Source>(this.sourcesToCheckMap);
    }
}

