/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.process;

import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.action.DeployBuildAction;
import ch.e2e.builder.compiler.build.event.ResetPasswordEvent;
import ch.e2e.builder.compiler.build.process.BuildProcess;
import ch.e2e.builder.compiler.build.tasks.DeployTask;
import ch.e2e.builder.compiler.error.DeployError;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.event.SendErrorEvent;
import ch.e2e.builder.compiler.event.SendInfoEvent;
import ch.e2e.builder.compiler.event.SendWarningEvent;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.builder.compiler.net.PageNotFoundException;
import ch.e2e.event.EventController;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.EventObject;

public abstract class DeployProcess
extends BuildProcess {
    public void start(DeployBuildAction buildAction) {
        DeployErrorHandler errorHandler;
        block10: {
            this.setBuildAction(buildAction);
            this.startTime = new Date().getTime();
            this.getReplaceMap().put("url", buildAction.getLogin().getUrl());
            this.getReplaceMap().put("composite.name", buildAction.getBuildSource());
            errorHandler = buildAction.getErrorHandler();
            errorHandler.resetErrorsCleared();
            errorHandler.clear();
            try {
                Login login = buildAction.getLogin();
                String cookie = login.doLogin("admin/Console/Welcome");
                if (cookie == null) {
                    throw new LoginFailedException();
                }
                login.setCookie(cookie);
                DeployTask deployTask = this.getDeployTask(buildAction);
                deployTask.setReplaceMap(this.getReplaceMap());
                this.start(deployTask);
            }
            catch (PageNotFoundException pnfEx) {
                this.doDeployErrorHandling("error.deploy.page.not.found", errorHandler);
            }
            catch (MalformedURLException muEx) {
                this.doDeployErrorHandling("error.deploy.malformed.url", errorHandler);
            }
            catch (UnknownHostException uhEx) {
                this.getReplaceMap().put("host", uhEx.getMessage());
                this.doDeployErrorHandling("error.deploy.unknown.host", errorHandler);
            }
            catch (ConnectException cEx) {
                this.doDeployErrorHandling("error.deploy.connect", errorHandler);
            }
            catch (LoginFailedException ex) {
                this.doDeployErrorHandling("error.deploy.login.failed", errorHandler);
                EventController.fire((EventObject)new ResetPasswordEvent(this));
            }
            catch (IOException ex) {
                this.doDeployErrorHandling(ex.getMessage(), errorHandler);
            }
            catch (Throwable ex) {
                String message = ex.getMessage() == null ? "" : ex.getMessage();
                int index = message.indexOf("Exception:");
                if (index != -1) {
                    message = message.substring(index + 10).trim();
                }
                this.doDeployErrorHandling(message, errorHandler);
                if (!(ex instanceof RuntimeException)) break block10;
                throw (RuntimeException)ex;
            }
        }
        errorHandler.serialize(true);
        this.showDeployEndStatus(errorHandler);
    }

    @Override
    public String getLogSource() {
        return this.getBuildAction().getBuildSource();
    }

    protected abstract DeployTask getDeployTask(DeployBuildAction var1) throws IOException;

    private void doDeployErrorHandling(String errorKey, DeployErrorHandler errorHandler) {
        DeployError error = new DeployError(errorKey, this.getReplaceMap());
        errorHandler.error(error);
        EventController.fire((EventObject)((Object)new SendErrorEvent(this.getSendEventSource(), (BuilderError)error)));
    }

    private void showDeployEndStatus(DeployErrorHandler errorHandler) {
        EventController.fire((EventObject)new SendStatusEvent((Object)this, ""));
        long time = (new Date().getTime() - this.startTime) / 1000L;
        String timeStr = String.valueOf(time);
        this.getReplaceMap().put("build.time", timeStr);
        int errorCount = errorHandler.getErrorCount();
        int warningCount = errorHandler.getWarningCount();
        this.getReplaceMap().put("error.count", String.valueOf(errorCount));
        this.getReplaceMap().put("warning.count", String.valueOf(warningCount));
        Object messageEvent = errorCount > 0 ? (warningCount > 0 ? new SendErrorEvent(this.getSendEventSource(), "deployment.with.errors.and.warnings", this.getReplaceMap()) : new SendErrorEvent(this.getSendEventSource(), "deployment.with.errors", this.getReplaceMap())) : (warningCount > 0 ? new SendWarningEvent(this.getSendEventSource(), "deployment.with.warnings", this.getReplaceMap()) : new SendInfoEvent(this.getSendEventSource(), "deployment.successfull", this.getReplaceMap()));
        EventController.fire((EventObject)messageEvent);
    }
}

