/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer;

import ch.e2e.builder.analyzer.Logging;
import ch.e2e.builder.analyzer.gui.MainPanel;
import ch.e2e.builder.analyzer.gui.tree.TransactionLogsTreeView;
import ch.e2e.builder.analyzer.gui.tree.TreeViewPane;
import ch.e2e.builder.analyzer.importer.ImportFromTransactionLogFileEvent;
import ch.e2e.builder.analyzer.importer.TransactionLogImporter;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.resource.Properties;
import com.jidesoft.swing.JideTabbedPane;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class Analyzer
extends E2ETraceModule
implements Logging,
ChangeListener,
TreeSelectionListener {
    private static String TITLE_MESSAGES;
    private static final String MODULE_NAME = "analyzer";
    private static final String KEY_TRANSACTION_LOG_IMPORT = "transactionLog_import";
    private static final String MENU_IMPORT_MENU = "analyzer.menu.import";
    private static final String MENU_IMPORT_TRANSACTION_LOG_FILE = "analyzer.menu.import.transactionLog.file";
    public static final HashMap<Class<?>, String[][]> enabledMenuEntries;
    public static final HashMap<Class<?>, String[][]> disabledMenuEntries;
    private TreeViewPane overviewPanel;
    private MainPanel mainPanel;
    private TransactionLogsRoot transactionLogsRoot;
    private E2EBuilderProject project;

    public Analyzer(ModuleInfo moduleInfo, Properties properties, String modulePackagePrefix) {
        super(moduleInfo, properties, modulePackagePrefix);
        TITLE_MESSAGES = this.getTranslation("analyzer.message.title");
        this.initializeRoots();
        this.createMenuEntries();
        this.addEventHandler();
    }

    public TreeViewPane getOverviewWindow() {
        return this.overviewPanel == null ? (this.overviewPanel = new TreeViewPane(this.transactionLogsRoot, this)) : this.overviewPanel;
    }

    public MainPanel getMainWindow() {
        return this.mainPanel == null ? (this.mainPanel = new MainPanel(this)) : this.mainPanel;
    }

    public Object getPrintableObject() {
        return this.getMainWindow().getPrintableObject();
    }

    public void refresh() {
        if (this.overviewPanel != null) {
            this.overviewPanel.refresh();
        }
    }

    private void createMenuEntries() {
        this.addMenuItem(new String[]{MENU_IMPORT_MENU, MENU_IMPORT_TRANSACTION_LOG_FILE}, null, new ImportFromTransactionLogFileEvent(), -1, new TransactionLogImporter(this.transactionLogsRoot, this));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof JideTabbedPane) {
            Class<?> aClass = ((JideTabbedPane)source).getSelectedComponent().getClass();
            this.updateMenuEntries(aClass);
            if (this.overviewPanel != null) {
                TreePath selectionPath = this.overviewPanel.getSelectedView().getSelectionPath();
                this.mainPanel.pathChanged(selectionPath);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.mainPanel.pathChanged(e.getNewLeadSelectionPath());
    }

    public void projectOpened(ProjectEvent event) {
        this.project = event.getProject();
        boolean enabled = this.project.getProjectHome() != null;
        this.setMenuEnabled(MENU_IMPORT_MENU, enabled);
        for (String[][] entries : enabledMenuEntries.values()) {
            for (String[] entry : entries) {
                this.setMenuItemEnabled(entry, enabled);
            }
        }
        this.setMenuItemEnabled(new String[]{"menu.project", "menu.project.preferences"}, enabled);
        this.clearMessages();
        this.refresh();
    }

    public File getLastTransactionLogFileImportPath() {
        File path = null;
        if (this.project == null) {
            logger.fine("project is null!");
        } else {
            path = this.project.get(MODULE_NAME, KEY_TRANSACTION_LOG_IMPORT, (File)null);
        }
        return path;
    }

    public void setLastTransactionLogFileImportPath(File path) {
        if (this.project == null) {
            logger.fine("project is null!");
        } else {
            try {
                this.project.set(MODULE_NAME, KEY_TRANSACTION_LOG_IMPORT, (Object)path);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void clearMessages() {
        this.clearMessageView(TITLE_MESSAGES);
    }

    private void initializeRoots() {
        this.transactionLogsRoot = new TransactionLogsRoot();
    }

    private void updateMenuEntries(Class<?> clazz) {
        String[][] namesArray = enabledMenuEntries.get(clazz);
        if (namesArray != null) {
            for (String[] names : namesArray) {
                this.setMenuItemEnabled(names, true);
            }
        }
        if ((namesArray = disabledMenuEntries.get(clazz)) != null) {
            for (String[] names : namesArray) {
                this.setMenuItemEnabled(names, false);
            }
        }
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                Analyzer.this.showStatusMessage(((ShowStatusEvent)event).getMessage());
            }
        }, ShowStatusEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                Analyzer.this.showError(((ShowErrorEvent)event).getMessage(), TITLE_MESSAGES);
            }
        }, ShowErrorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                Analyzer.this.showInfo(((ShowInfoEvent)event).getMessage(), TITLE_MESSAGES);
            }
        }, ShowInfoEvent.class);
    }

    static {
        enabledMenuEntries = new HashMap();
        disabledMenuEntries = new HashMap();
        enabledMenuEntries.put(TransactionLogsTreeView.class, new String[][]{{MENU_IMPORT_MENU, MENU_IMPORT_TRANSACTION_LOG_FILE}});
    }

    private static class ShowMessageEvent
    extends EventObject {
        private final String message;

        public ShowMessageEvent(Object source, String message) {
            super(source);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class ShowErrorEvent
    extends ShowMessageEvent {
        public ShowErrorEvent(Object source, String message) {
            super(source, message);
        }
    }

    private static class ShowStatusEvent
    extends ShowMessageEvent {
        public ShowStatusEvent(Object source, String message) {
            super(source, message);
        }
    }

    private static class ShowInfoEvent
    extends ShowMessageEvent {
        public ShowInfoEvent(Object source, String message) {
            super(source, message);
        }
    }
}

