/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;

public class HighestOrLowest
extends SystemFunction {
    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        Object next;
        Configuration config = context.getConfiguration();
        Function function = arguments.length == 2 ? (Function)arguments[1].head() : config.makeSystemFunction("data", 1);
        Sequence[] args = new Sequence[1];
        AtomicValue maxSoFar = null;
        ArrayList highestSoFar = new ArrayList();
        StringCollator collator = config.getCollation(this.getRetainedStaticContext().getDefaultCollationName());
        if (collator == null) {
            XPathException e = new XPathException("Unknown collation " + this.getRetainedStaticContext().getDefaultCollationName());
            e.setErrorCode("FOCH0002");
            throw e;
        }
        AtomicComparer comparer = new GenericAtomicComparer(collator, context);
        if (this.getFunctionName().getLocalPart().equals("lowest")) {
            comparer = new DescendingComparer(comparer);
        }
        SequenceIterator iter = arguments[0].iterate();
        while ((next = iter.next()) != null) {
            int result;
            args[0] = next;
            Sequence<?> key = HighestOrLowest.dynamicCall(function, context, args);
            Object head = key.head();
            if (head == null) continue;
            if (!(head instanceof AtomicValue)) {
                throw new XPathException("Result of function supplied as second argument to " + this.getFunctionName().getDisplayName() + " must be an atomic value", "XPTY0004");
            }
            AtomicValue keyVal = (AtomicValue)key.head();
            if (keyVal instanceof UntypedAtomicValue) {
                StringToDouble converter = context.getConfiguration().getConversionRules().getStringToDoubleConverter();
                keyVal = new DoubleValue(converter.stringToNumber(keyVal.getStringValueCS()));
            }
            if (keyVal.isNaN()) continue;
            if (!keyVal.getPrimitiveType().isOrdered(false)) {
                XPathException de = new XPathException("Type " + keyVal.getPrimitiveType() + " is not an ordered type");
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
            if (maxSoFar == null) {
                highestSoFar.add(next);
                maxSoFar = keyVal;
                continue;
            }
            try {
                result = comparer.compareAtomicValues(keyVal, maxSoFar);
            }
            catch (ClassCastException e) {
                throw new XPathException("Keys computed for " + this.getFunctionName().getDisplayName() + " are not comparable", "FORG0006");
            }
            if (result > 0) {
                highestSoFar.clear();
                highestSoFar.add(next);
                maxSoFar = keyVal;
                continue;
            }
            if (result != 0) continue;
            highestSoFar.add(next);
        }
        return new SequenceExtent(highestSoFar);
    }
}

