/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.EXPathFile;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.StringValue;

public class EXPathFileFunctionSet
extends BuiltInFunctionSet {
    private static EXPathFileFunctionSet THE_INSTANCE = new EXPathFileFunctionSet();

    public static EXPathFileFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private EXPathFileFunctionSet() {
        this.init();
    }

    private void init() {
        this.register("base-dir", 0, BaseDir.class, AnyItemType.getInstance(), 24576, 0, 0);
    }

    @Override
    public String getNamespace() {
        return "http://expath.org/ns/file";
    }

    @Override
    public String getConventionalPrefix() {
        return "file";
    }

    public static class BaseDir
    extends SystemFunction {
        @Override
        public Expression makeFunctionCall(Expression ... arguments) {
            if (this.getRetainedStaticContext().getPackageData().isRelocatable()) {
                return super.makeFunctionCall(arguments);
            }
            try {
                return Literal.makeLiteral(BaseDir.makeResult(this.getStaticBaseUriString()));
            }
            catch (XPathException e) {
                return new ErrorExpression(e);
            }
        }

        @Override
        public Sequence<?> call(XPathContext context, Sequence[] args) throws XPathException {
            return BaseDir.makeResult(this.getStaticBaseUriString());
        }

        private static ZeroOrOne<StringValue> makeResult(String baseURI) throws XPathException {
            if (baseURI == null) {
                return ZeroOrOne.empty();
            }
            String parent = EXPathFile._parent(baseURI);
            if (parent == null) {
                return ZeroOrOne.empty();
            }
            return new ZeroOrOne<StringValue>(StringValue.makeStringValue(parent));
        }
    }
}

