/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class MemoFunction
extends UserFunction {
    @Override
    public void computeEvaluationMode() {
        this.evaluator = ExpressionTool.eagerEvaluator(this.getBody());
    }

    @Override
    public boolean isMemoFunction() {
        return true;
    }

    @Override
    public Sequence<?> call(XPathContext context, Sequence[] actualArgs) throws XPathException {
        Sequence<?> value;
        String key = MemoFunction.getCombinedKey(actualArgs);
        Controller controller = context.getController();
        HashMap map = (HashMap)controller.getUserData(this, "memo-function-cache");
        Sequence<?> sequence = value = map == null ? null : (Sequence<?>)map.get(key);
        if (value != null) {
            return value;
        }
        value = super.call(context, actualArgs);
        if (map == null) {
            map = new HashMap(32);
            controller.setUserData(this, "memo-function-cache", map);
        }
        map.put(key, value);
        return value;
    }

    private static String getCombinedKey(Sequence[] params) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(256);
        for (Sequence val : params) {
            Object item;
            SequenceIterator iter = val.iterate();
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo node = (NodeInfo)item;
                    node.generateId(sb);
                } else if (item instanceof QNameValue) {
                    sb.append("" + Type.displayTypeName(item));
                    sb.append('/');
                    sb.append(((QNameValue)item).getClarkName());
                } else if (item instanceof AtomicValue) {
                    sb.append("" + Type.displayTypeName(item));
                    sb.append('/');
                    sb.append(item.getStringValueCS());
                } else if (item instanceof Function) {
                    sb.append(item.getClass().getName() + "@" + System.identityHashCode(item));
                }
                sb.append('\u0001');
            }
            sb.append('\u0002');
        }
        return sb.toString();
    }
}

