import {Component, OnInit} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {NotificationService, ProgressService} from '@pas/app-core';
import {ProcessService, InstanceMetadata} from '@pas/xuml-communication';

@Component({
    templateUrl: './start.component.html'
})
export class StartComponent implements OnInit {
    public processName = '';
    public startName = '';

    constructor(
        private route: ActivatedRoute,
        private router: Router,
        private process: ProcessService,
        private notification: NotificationService,
        private progress: ProgressService
    ) {
        this.router.onSameUrlNavigation = 'reload';
    }

    ngOnInit() {
        this.route.data.subscribe((data: { processName: string, startName: string }) => {
            this.processName = data.processName;
            this.startName = data.startName;
            this.createInstance();
        });
    }

    private async createInstance(): Promise<void> {

        this.progress.start();

        try {
            let instance: InstanceMetadata = await this.process.sendStart(this.processName, this.startName);
            await this.router.navigate([this.processName , instance.id], {
                replaceUrl: false,
                skipLocationChange: true
            });
        } catch (error) {
            this.notification.sendNotification({
                type: 'error',
                message: error.message,
                data: {
                    error: error
                }
            });
            await this.router.navigate([this.processName],{
                replaceUrl: true
            });
        } finally {
            this.progress.stop();
        }

    }
}
