/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.dom.DomUtilities;
import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathFindTask
extends Task {
    private String xpath;
    private String attribute;
    private String property;
    private File document;

    public void execute() throws BuildException {
        if (this.xpath == null) {
            throw new BuildException("The attribute 'xpath' must be specified.");
        }
        if (this.property == null) {
            throw new BuildException("The attribute 'property' must be specified.");
        }
        if (this.document == null) {
            throw new BuildException("The attribute 'document' must be specified.");
        }
        try {
            Document doc = DomUtilities.parse((File)this.document, (boolean)false, (boolean)false);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate(this.xpath, doc.getDocumentElement(), XPathConstants.NODE);
            if (node != null) {
                String value = null;
                if (this.attribute == null) {
                    value = node.getFirstChild().getNodeValue();
                } else if (node instanceof Element && ((Element)node).hasAttribute(this.attribute)) {
                    value = ((Element)node).getAttribute(this.attribute);
                }
                if (value != null) {
                    if (this.getProject().getProperty(this.property) == null) {
                        this.getProject().setNewProperty(this.property, value);
                    } else {
                        this.getProject().setProperty(this.property, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void setDocument(File document) {
        this.document = document;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

