/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.ErrorHandlerMulticaster;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;

public class XSLTErrorHandler
extends AbstractErrorHandler {
    private static XSLTErrorHandler instance = new XSLTErrorHandler();
    private AbstractErrorHandler errorHandler;

    public static XSLTErrorHandler getInstance() {
        return instance;
    }

    public void addErrorHandler(AbstractErrorHandler errorHandler) {
        this.errorHandler = ErrorHandlerMulticaster.add(this.errorHandler, errorHandler);
    }

    public void removeErrorHandler(AbstractErrorHandler errorHandler) {
        this.errorHandler = ErrorHandlerMulticaster.remove(this.errorHandler, errorHandler);
    }

    @Override
    public BuilderError error(Throwable exception) {
        BuilderError result = super.error(exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
        return result;
    }

    @Override
    public BuilderError error(AbstractBuilderError error) {
        BuilderError result = super.error(error);
        if (this.errorHandler != null) {
            result = this.errorHandler.error(error);
        }
        return result;
    }

    @Override
    public BuilderWarning warning(BuilderWarning warning) {
        BuilderWarning result = super.warning(warning);
        if (this.errorHandler != null) {
            result = this.errorHandler.warning(warning);
        }
        return result;
    }

    @Override
    public BuilderFatalError fatalError(BuilderFatalError fatalError) {
        BuilderFatalError result = super.fatalError(fatalError);
        if (this.errorHandler != null) {
            result = this.errorHandler.fatalError(fatalError);
        }
        return result;
    }

    @Override
    public void error(SAXParseException exception) {
        super.error(exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) {
        super.warning(exception);
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        super.fatalError(exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    @Override
    public void clear() {
        super.clear(true);
        if (this.errorHandler != null) {
            this.errorHandler.clear(true);
        }
    }

    public void reset() {
        this.clear();
        this.errorHandler = null;
    }

    public void dumpErrorsAndWarnings() {
        System.err.println(this.getClass().getName() + ".dumpErrorsAndWarnings(): Dumping all errors ...");
        List<BuilderError> errors = this.getAllErrorsAndWarnings();
        for (BuilderError error : errors) {
            System.err.println(error.getClass().getName() + ": " + error.getCode());
        }
    }

    public void addAllWarnings(ArrayList warnings) {
        for (Object warning : warnings) {
            this.warning((BuilderWarning)warning);
        }
    }
}

