/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.SelectTestActionDialog;
import ch.e2e.builder.regtest.gui.TestcasePreferencesDialog;
import ch.e2e.builder.regtest.testsuite.TestSuiteRoot;
import ch.e2e.builder.regtest.testsuite.TestableSettings;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestcaseFactory {
    private static TestcaseFactory factory;
    private SelectTestActionDialog testActionSelection;

    private TestcaseFactory() {
    }

    public static TestcaseFactory getInstance() {
        if (factory == null) {
            factory = new TestcaseFactory();
        }
        return factory;
    }

    public List<TestcaseSettings> createTestcase(TreeTestSuite parent, int index, E2EBuilderModule module) {
        ArrayList<TestcaseSettings> result = new ArrayList<TestcaseSettings>();
        SelectTestActionDialog.TestActionSettings testActionSettings = this.getTestActionSelection(module).selectTestAction(parent, index == 0 && !(parent.getParent() instanceof TestSuiteRoot));
        if (testActionSettings != null) {
            try {
                parent = testActionSettings.getParent();
                TestType testAction = testActionSettings.getTestType();
                E2ETest[] tests = testAction.hasCreateAction() ? testAction.getCreateAction().create(E2EBuilder.getInstance().getApplicationFrame()) : new E2ETest[]{(E2ETest)testAction.newInstance()};
                if (tests != null) {
                    Testcase[] testcases = this.initializeTests(tests, testAction, parent);
                    int resultIndex = index == 0 ? testActionSettings.getIndex() : index;
                    int offset = 0;
                    for (Testcase testcase : testcases) {
                        if (!TestcasePreferencesDialog.getInstance(module).rename(testcase, true)) continue;
                        TestcaseSettings settings = new TestcaseSettings(parent, resultIndex + offset);
                        settings.setTestcase(testcase);
                        ++offset;
                        result.add(settings);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Testcase[] initializeTests(E2ETest[] tests, TestType testAction, TreeTestSuite parent) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Testcase[] result = new Testcase[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            TestType compareType;
            result[i] = new Testcase(testAction.getName(), tests[i], parent);
            E2ETestResult testResult = new E2ETestResult();
            tests[i].setResult(testResult);
            if (tests[i].getRecommendedCompareType() == null || (compareType = TypeFactory.getInstance().getType(tests[i].getRecommendedCompareType())) == null) continue;
            ResultCompare compare = (ResultCompare)compareType.newInstance();
            Utilities.mergeOptions((OptionContainer)parent.getInheritedOptions(compareType, true), (OptionContainer)compare);
            tests[i].prepareCompareType(compare);
            testResult.setResultCompares(Arrays.asList(compare), (Testable)result[i]);
        }
        return result;
    }

    private SelectTestActionDialog getTestActionSelection(E2EBuilderModule module) {
        if (this.testActionSelection == null) {
            this.testActionSelection = new SelectTestActionDialog(module);
        }
        return this.testActionSelection;
    }

    public static class TestcaseSettings
    extends TestableSettings {
        private Testcase testcase;

        public TestcaseSettings(TreeTestSuite parent, int index) {
            super(parent, index);
        }

        public Testcase getTestcase() {
            return this.testcase;
        }

        public void setTestcase(Testcase testcase) {
            this.testcase = testcase;
        }
    }
}

