/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.regtest.model.SelectionTreeModel;
import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.regtest.testsuite.TraceTestcaseRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TestSelectionTreeView
extends JScrollPane
implements ProjectListener,
TreeSelectionListener,
ItemSelectable {
    private Tree tree;
    private E2EBuilderModule module;
    private TraceTestcaseRoot root;
    private boolean internalChange;
    private ItemListener itemListener;

    public TestSelectionTreeView(E2EBuilderModule module, boolean testSuiteSelection, SelectionTreeModel treeModel) {
        super(20, 30);
        this.module = module;
        this.root = (TraceTestcaseRoot)treeModel.getRoot();
        module.addProjectListener((ProjectListener)this);
        this.createGui(treeModel);
        this.addEventHandler();
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public TestcaseContainer[] getSelectedObjects() {
        TestcaseContainer[] result;
        int[] selectedRows = this.tree.getSelectionRows();
        if (selectedRows == null) {
            result = new TestcaseContainer[]{};
        } else {
            Arrays.sort(selectedRows);
            result = new TestcaseContainer[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                TreePath selectedPath = this.tree.getPathForRow(selectedRows[i]);
                result[i] = (TestcaseContainer)selectedPath.getLastPathComponent();
            }
        }
        return result;
    }

    public Object getSelectedComponent() {
        return this.tree.getSelectionPath().getLastPathComponent();
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.internalChange) {
            boolean selectable;
            this.internalChange = true;
            ArrayList<TreePath> paths = new ArrayList<TreePath>(Arrays.asList(e.getPaths()));
            TreePath selectionPath = e.getPath();
            Object pathComponent = selectionPath.getLastPathComponent();
            boolean bl = selectable = pathComponent instanceof TestImportTreeNode && ((TestImportTreeNode)pathComponent).isSelectable();
            if (selectable) {
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, selectionPath, 1));
                }
            } else {
                paths.remove(selectionPath);
                TreePath[] selectionPaths = new TreePath[paths.size()];
                this.tree.setSelectionPaths(paths.toArray(selectionPaths));
            }
            this.internalChange = false;
        }
    }

    public void expandAll() {
        this.tree.expandAll();
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public File getProjectHome() {
        return this.root.getProjectHome();
    }

    public void setProjectHome(File projectHome) {
        this.root.setProjectHome(projectHome);
        this.tree.refresh();
        this.tree.clearSelection();
        this.tree.expandAll();
    }

    public void setMultiSelection(boolean multiSelection) {
        this.tree.getSelectionModel().setSelectionMode(multiSelection ? 4 : 1);
    }

    public void selectAll() {
        this.tree.expandAll();
        Collection<TreePath> selectablePaths = this.root.getSelectablePaths();
        TreePath[] paths = new TreePath[selectablePaths.size()];
        selectablePaths.toArray(paths);
        this.tree.setSelectionPaths(paths);
    }

    public void selectNone() {
        this.tree.clearSelection();
    }

    public void setExistingNames(TreeTestSuite testSuite) {
        HashSet<String> existingNames = new HashSet<String>();
        if (testSuite != null) {
            testSuite.findExistingTestNames(existingNames);
        }
        this.root.setExistingNames(existingNames);
    }

    public void setExistingPaths(TreeTestSuite testSuite) {
        HashSet<String> existingPaths = new HashSet<String>();
        if (testSuite != null) {
            testSuite.findExistingTestPaths(existingPaths, null);
        }
        this.root.setExistingPaths(existingPaths, "");
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(itemListener, this.itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(itemListener, this.itemListener);
    }

    private void addEventHandler() {
    }

    private void createGui(SelectionTreeModel treeModel) {
        this.tree = new Tree((AbstractTreeModel)treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToolTipsEnabled(true);
        this.tree.setEditable(false);
        this.setViewportView((Component)this.tree);
    }

    public void expandAll(TreePath selectionPath) {
        this.tree.expandAll(selectionPath);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }
}

