/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.filechooser.DirectoryComboBox;
import ch.e2e.swing.filechooser.FileChooserConstants;
import ch.e2e.swing.filechooser.FileChooserIcons;
import ch.e2e.swing.model.Directory;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class DirectoryComboBoxCellRenderer
extends BasicComboBoxRenderer
implements FileChooserIcons {
    private DirectoryComboBox comboBox;

    public DirectoryComboBoxCellRenderer(DirectoryComboBox comboBox) {
        this.comboBox = comboBox;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list != null) {
            block6: {
                if (value instanceof Directory) {
                    Directory directory = (Directory)value;
                    this.setIcon(directory);
                    try {
                        if (this.comboBox.isPopupVisible()) {
                            this.setBorder(new EmptyBorder(0, this.getDepth(directory) * 16 + 3, 0, 0));
                            break block6;
                        }
                        this.setBorder(new EmptyBorder(0, 3, 0, 0));
                    }
                    catch (Exception e) {
                        this.setBorder(new EmptyBorder(0, 3, 0, 0));
                    }
                } else {
                    this.setBorder(new EmptyBorder(0, 3, 0, 0));
                    this.setIcon(filesystemIcon);
                }
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        return this;
    }

    private void setIcon(Directory directory) {
        if (directory.getParent() == null) {
            this.setIcon(filesystemIcon);
        } else if (directory.isRoot() && FileChooserConstants.WINDOWS) {
            this.setIcon(discIcon);
        } else {
            this.setIcon(folderIcon);
        }
    }

    private int getDepth(Directory directory) {
        int depth = 0;
        Directory parent = directory;
        while ((parent = parent.getParent()) != null) {
            ++depth;
        }
        return depth;
    }
}

