/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.resource.Properties;
import ch.e2e.swing.Message;
import ch.e2e.swing.MessageGroup;
import ch.e2e.swing.MessagePopupMenu;
import ch.e2e.swing.MessageType;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.event.MessageActionEvent;
import ch.e2e.swing.event.MessageActionEventMulticaster;
import ch.e2e.swing.event.MessageActionListener;
import ch.e2e.swing.event.MessageGroupChangedEvent;
import ch.e2e.swing.event.MessageGroupChangedListener;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class MessageTextPaneModel
extends AbstractTreeModel
implements MessageGroupChangedListener {
    private static final int MESSAGE_GROUP_TYPE = -9876;
    private MessagesRoot root;
    private HashMap<Integer, MessageType> messageTypes = new HashMap();
    private HashMap<Integer, MessageGroup> messageGroups = new HashMap();
    private MessageActionListener messageListener;
    private MessageAction messageAction;
    private MessagePopup messagePopup;

    public MessageTextPaneModel() {
        super(new Properties());
        this.root = new MessagesRoot();
        this.messageAction = new MessageAction();
        this.messagePopup = new MessagePopup();
    }

    public TreePath appendMessage(Message message) {
        TreePath result;
        if (message.getGroup() == null) {
            this.root.add(message);
            result = new TreePath(new Object[]{this.root, message});
        } else {
            MessageGroup group = message.getGroup();
            if (!this.messageGroups.containsKey(group.getName().hashCode())) {
                this.messageGroups.put(group.getName().hashCode(), group);
                this.messageTypes.put(group.getMessageType().type.hashCode(), group.getMessageType());
                group.addMessageGroupChangedListener(this);
                this.root.add(group);
            }
            group.add(message);
            result = new TreePath(new Object[]{this.root, group, message});
        }
        this.messageTypes.put(message.getMessageType().type.hashCode(), message.getMessageType());
        this.fireTreeStructureChanged(new TreePath(this.root));
        return result;
    }

    public void addMessageActionListener(MessageActionListener messageListener) {
        this.messageListener = MessageActionEventMulticaster.addListener(this.messageListener, messageListener);
    }

    public void removeMessageActionListener(MessageActionListener messageListener) {
        this.messageListener = MessageActionEventMulticaster.removeListener(this.messageListener, messageListener);
    }

    public void clear() {
        this.root.clear();
        for (MessageGroup group : this.messageGroups.values()) {
            group.clear();
            group.removeMessageGroupChangedListener(this);
        }
        this.messageGroups.clear();
        this.fireTreeStructureChanged(new TreePath(this.root));
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getType(Object value) {
        int result = value instanceof Message ? ((Message)value).getMessageType().type.hashCode() : (value instanceof MessageGroup ? ((MessageGroup)value).getMessageType().type.hashCode() : super.getType(value));
        return result;
    }

    @Override
    public Color getTypeColor(int type, boolean leaf, boolean expanded, boolean selected) {
        MessageType messageType = this.messageTypes.get(type);
        return messageType == null ? super.getTypeColor(type, leaf, expanded, selected) : messageType.foreground;
    }

    @Override
    public Icon getTypeIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon result = null;
        if (type != -9876) {
            MessageType messageType = this.messageTypes.get(type);
            result = messageType == null ? super.getTypeIcon(type, leaf, expanded, selected) : messageType.icon;
        }
        return result;
    }

    @Override
    public String getTypeString(int type) {
        return null;
    }

    @Override
    public ActionListener getExecuteAction(TreePath[] paths) {
        ActionListener result;
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof Message) {
            this.messageAction.message = (Message)paths[0].getLastPathComponent();
            result = this.messageAction;
        } else {
            result = paths.length == 1 && paths[0].getLastPathComponent() instanceof MessageGroup ? ((MessageGroup)paths[0].getLastPathComponent()).getExecuteAction() : super.getExecuteAction(paths);
        }
        return result;
    }

    @Override
    public JPopupMenu getPopupMenu(TreePath[] paths) {
        JPopupMenu result;
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof MessageGroup) {
            result = ((MessageGroup)paths[0].getLastPathComponent()).getPopupMenu();
        } else if (paths.length == 1 && paths[0].getLastPathComponent() instanceof Message) {
            Message message = (Message)paths[0].getLastPathComponent();
            MessagePopupMenu messagePopup = null;
            MessageGroup messageGroup = this.findMessageGroup(paths[0]);
            messagePopup = messageGroup == null ? this.messagePopup : (messageGroup.getMessagePopup(message) == null ? this.messagePopup : messageGroup.getMessagePopup(message));
            messagePopup.setMessage(message);
            result = messagePopup;
        } else {
            result = super.getPopupMenu(paths);
        }
        return result;
    }

    private MessageGroup findMessageGroup(TreePath path) {
        MessageGroup result = null;
        Object lastElement = path.getLastPathComponent();
        while (lastElement != null && result == null) {
            if (lastElement instanceof MessageGroup) {
                result = (MessageGroup)lastElement;
                continue;
            }
            if ((path = path.getParentPath()) == null) {
                lastElement = null;
                continue;
            }
            lastElement = path.getLastPathComponent();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.root.size() == 0;
    }

    @Override
    public void groupChanged(MessageGroupChangedEvent event) {
        this.fireTreeStructureChanged(new TreePath(this.root));
    }

    private class MessagePopup
    extends MessagePopupMenu {
        private MessagePopup() {
        }

        @Override
        protected void addItems() {
        }
    }

    private class MessageAction
    implements ActionListener {
        private Message message;

        private MessageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MessageTextPaneModel.this.messageListener != null) {
                MessageTextPaneModel.this.messageListener.doMessageAction(new MessageActionEvent(MessageTextPaneModel.this, this.message));
            }
        }
    }

    private class MessagesRoot
    extends ArrayList<Object>
    implements TreeObject {
        private MessagesRoot() {
        }

        public Object getChild(int index) {
            return this.get(index);
        }

        @Override
        public int getChildCount() {
            return this.size();
        }

        public int getIndexOfChild(Object child) {
            return this.indexOf(child);
        }

        @Override
        public boolean isLeaf() {
            return this.size() == 0;
        }

        @Override
        public int getType() {
            return 0;
        }
    }
}

