/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.io.FileUtilities;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.util.DirectoryFilter;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;

public class FileListModel
extends AbstractListModel {
    private ArrayList files = new ArrayList();
    private Directory selectedDirectory;
    private FileFilter selectedFileFilter;
    private long lastModified = -1L;
    private boolean includeDirectories = true;
    private FileListModelExtension extension;

    public void setExtension(FileListModelExtension extension) {
        this.extension = extension;
    }

    public ActionListener getAction(File file) {
        return this.extension == null ? null : this.extension.getAction(file);
    }

    public ActionListener getMultipleSelectionAction() {
        return this.extension == null ? null : this.extension.getMultipleSelectionAction();
    }

    @Override
    public int getSize() {
        return this.files.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index > -1 && index < this.files.size()) {
            return this.files.get(index);
        }
        return null;
    }

    public void setSelectedFileFilter(FileFilter selectedFileFilter) {
        if (this.selectedFileFilter == null && selectedFileFilter != null || selectedFileFilter != null && !selectedFileFilter.equals(this.selectedFileFilter) || this.selectedFileFilter != null && !this.selectedFileFilter.equals(selectedFileFilter)) {
            this.selectedFileFilter = selectedFileFilter;
            this.lastModified = -1L;
            if (this.selectedDirectory != null) {
                this.reload();
            }
        }
    }

    public void setSelectedDirectory(Directory selectedDirectory) {
        if (selectedDirectory == null && this.selectedDirectory != null || selectedDirectory != null && this.selectedDirectory == null || !selectedDirectory.equals(this.selectedDirectory)) {
            this.selectedDirectory = selectedDirectory;
            this.lastModified = -1L;
            this.reload();
        }
    }

    public int[] getIndices(File[] fileArray) {
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        for (int i = 0; i < fileArray.length; ++i) {
            int index = this.indexOf(fileArray[i]);
            if (index == -1) continue;
            indicesList.add(new Integer(index));
        }
        int[] indices = new int[indicesList.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)indicesList.get(i);
        }
        return indices;
    }

    public int indexOf(File file) {
        int result;
        if (file == null) {
            result = -1;
        } else {
            Object value = file.isDirectory() ? Directory.getDirectory(file) : file;
            result = this.files.indexOf(value);
        }
        return result;
    }

    public void setIncludeDirectories(boolean includeDirectories) {
        if (this.includeDirectories ^ includeDirectories) {
            this.includeDirectories = includeDirectories;
            this.internalReload();
        }
    }

    public void reload() {
        if (this.lastModified < this.selectedDirectory.lastModified()) {
            this.lastModified = this.selectedDirectory.lastModified();
            this.internalReload();
        }
    }

    private void internalReload() {
        this.files.clear();
        if (!(this.selectedFileFilter instanceof DirectoryFilter) && this.includeDirectories) {
            this.files.addAll(this.selectedDirectory.getSubdirs());
        }
        if (this.selectedFileFilter != null && this.selectedDirectory.getDir() != null) {
            Object[] fileArray = FileUtilities.getFileList((File)this.selectedDirectory.getDir(), (FileFilter)this.selectedFileFilter, (boolean)false);
            Arrays.sort(fileArray);
            if (this.selectedFileFilter instanceof DirectoryFilter) {
                for (int i = 0; i < fileArray.length; ++i) {
                    Directory directory = Directory.getDirectory((File)fileArray[i]);
                    this.files.add(directory);
                }
            } else {
                this.files.addAll(Arrays.asList(fileArray));
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }
}

