/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.filechooser.FileChooserIcons;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FileIconPool
implements FileChooserIcons {
    private static FileIconPool sharedInstance;
    private Hashtable iconTable = new Hashtable();
    private ImageIcon newFile;
    private ImageIcon unknownFile;

    private FileIconPool() {
        this.registerIcon("wsdl", "ch/e2e/swing/filechooser/file.wsdl.gif");
        this.registerIcon("xml", "ch/e2e/swing/filechooser/file_xml.gif");
        this.registerIcon("xsd", "ch/e2e/swing/filechooser/file_xsd.gif");
        this.registerIcon("txt", "ch/e2e/swing/filechooser/file_text.gif");
        this.registerIcon("zip", "ch/e2e/swing/filechooser/file_zip.gif");
        this.unknownFile = ImageLoader.loadIcon((String)"ch/e2e/swing/filechooser/file.unknown.gif", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        this.newFile = ImageLoader.loadIcon((String)"ch/e2e/swing/filechooser/file.new.gif", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
    }

    public static FileIconPool getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new FileIconPool();
        }
        return sharedInstance;
    }

    public void registerIcon(String fileExtension, String imageName) {
        this.registerIcon(fileExtension, imageName, FileIconPool.class.getClassLoader());
    }

    public void registerIcon(String fileExtension, String imageName, ClassLoader classLoader) {
        this.registerIcon(fileExtension, ImageLoader.loadIcon((String)imageName, (boolean)true, (ClassLoader)classLoader));
    }

    public void registerIcon(String fileExtension, Icon icon) {
        this.iconTable.put(fileExtension.toLowerCase(), icon);
    }

    public Icon getIcon(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        String extension = index == -1 ? filename : filename.substring(index + 1);
        Icon result = (Icon)this.iconTable.get(extension.toLowerCase());
        if (result == null && file.isDirectory()) {
            result = folderIcon;
        } else if (!file.exists()) {
            result = this.newFile;
        }
        if (result == null) {
            result = this.unknownFile;
        }
        return result;
    }
}

