/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.document.HexDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class HexEditor
extends JPanel {
    private JTextArea hexField;
    private JTextArea charField;
    private JScrollPane textPanel;
    private JPanel viewPort;

    public HexEditor() {
        super(new BorderLayout());
        this.createGui();
        this.setBorder(null);
    }

    @Override
    public void addNotify() {
        Font monospaced = new Font("monospaced", this.getFont().getStyle(), this.getFont().getSize());
        this.hexField.setFont(monospaced);
        this.charField.setFont(monospaced);
        super.addNotify();
    }

    @Override
    public void setFont(Font font) {
        if (this.hexField != null) {
            Font monospaced = new Font("monospaced", font.getStyle(), font.getSize());
            this.hexField.setFont(monospaced);
            this.charField.setFont(monospaced);
        }
        super.setFont(font);
    }

    public void setText(String text) {
        this.charField.setText("");
        this.hexField.setText(text);
    }

    public void setEditable(boolean editable) {
        if (this.hexField != null) {
            this.hexField.setEditable(editable);
            this.charField.setEditable(editable);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.hexField != null) {
            this.textPanel.setBackground(bg);
            this.hexField.setBackground(bg);
            this.charField.setBackground(bg);
            this.viewPort.setBackground(bg);
        }
        super.setBackground(bg);
    }

    private void createGui() {
        this.viewPort = new JPanel(new GridBagLayout());
        this.hexField = new JTextArea(1, 39);
        this.hexField.setBorder(new EmptyBorder(0, 0, 0, 15));
        this.hexField.setLineWrap(true);
        this.hexField.setWrapStyleWord(true);
        HexDocument document = new HexDocument();
        this.hexField.setDocument(document);
        this.charField = new JTextArea(1, 16);
        this.charField.setBorder(null);
        this.charField.setLineWrap(true);
        this.charField.setWrapStyleWord(false);
        this.charField.setDocument(document.getCharDocument());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 18;
        this.viewPort.add((Component)this.hexField, c);
        c.weightx = 1.0;
        this.viewPort.add((Component)this.charField, c);
        this.viewPort.setBackground(this.hexField.getBackground());
        this.viewPort.setOpaque(true);
        this.textPanel = new JScrollPane(this.viewPort);
        this.textPanel.setBackground(this.hexField.getBackground());
        this.textPanel.setOpaque(true);
        this.add(this.textPanel);
    }
}

