/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Vector;

public class DirectionLayout
implements LayoutManager2 {
    public static final Integer SOUTH = new Integer(1);
    public static final Integer SOUTH_WEST = new Integer(2);
    public static final Integer WEST = new Integer(3);
    public static final Integer NORTH_WEST = new Integer(4);
    public static final Integer NORTH = new Integer(5);
    public static final Integer NORTH_EAST = new Integer(6);
    public static final Integer EAST = new Integer(7);
    public static final Integer SOUTH_EAST = new Integer(8);
    public static final Integer CENTER = new Integer(9);
    private static final int SOUTH_INT = 1;
    private static final int SOUTH_WEST_INT = 2;
    private static final int WEST_INT = 3;
    private static final int NORTH_WEST_INT = 4;
    private static final int NORTH_INT = 5;
    private static final int NORTH_EAST_INT = 6;
    private static final int EAST_INT = 7;
    private static final int SOUTH_EAST_INT = 8;
    private static final int CENTER_INT = 9;
    private Vector components = new Vector();
    private int constraints = 9;
    private Dimension preferredSize;

    public DirectionLayout(Integer direction) {
        this.constraints = direction;
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        this.components.addElement(component);
        try {
            this.constraints = (Integer)constraints;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        component.setName(name);
        this.components.addElement(component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.components.removeElement(component);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension containerSize = parent.getSize();
        this.evaluatePreferredSize();
        this.doLayout(containerSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (this.preferredSize == null) {
            this.evaluatePreferredSize();
        }
        return this.preferredSize;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void evaluatePreferredSize() {
        int width = this.getMaxWidth();
        int height = this.getHeight();
        this.preferredSize = new Dimension(width, height);
    }

    private int getMaxWidth() {
        int width = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            int dummy = ((Component)this.components.elementAt((int)i)).getPreferredSize().width;
            if (dummy <= width) continue;
            width = dummy;
        }
        return width;
    }

    private int getHeight() {
        int height = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            height += ((Component)this.components.elementAt((int)i)).getPreferredSize().height;
        }
        return height;
    }

    private void doLayout(Dimension containerSize) {
        int height;
        int width = containerSize.width;
        if (width < this.preferredSize.width) {
            width = this.preferredSize.width;
        }
        if ((height = containerSize.height) < this.preferredSize.height) {
            height = this.preferredSize.height;
        }
        switch (this.constraints) {
            case 5: {
                this.doNorthLayout(width, height);
                break;
            }
            case 6: {
                this.doNorthEastLayout(width, height);
                break;
            }
            case 7: {
                this.doEastLayout(width, height);
                break;
            }
            case 8: {
                this.doSouthEastLayout(width, height);
                break;
            }
            case 1: {
                this.doSouthLayout(width, height);
                break;
            }
            case 2: {
                this.doSouthWestLayout(width, height);
                break;
            }
            case 3: {
                this.doWestLayout(width, height);
                break;
            }
            case 4: {
                this.doNorthWestLayout(width, height);
            }
        }
    }

    private void doNorthLayout(int width, int height) {
        int yPos = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds((width - size.width) / 2, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doNorthEastLayout(int width, int height) {
        int yPos = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(width - size.width, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doEastLayout(int width, int height) {
        int yPos = (height - this.preferredSize.height) / 2;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(width - size.width, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doSouthEastLayout(int width, int height) {
        int yPos = height - this.preferredSize.height;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(width - size.width, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doSouthLayout(int width, int height) {
        int yPos = height - this.preferredSize.height;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds((this.preferredSize.width - size.width) / 2, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doSouthWestLayout(int width, int height) {
        int yPos = height - this.preferredSize.height;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(0, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doWestLayout(int width, int height) {
        int yPos = (height - this.preferredSize.height) / 2;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds((width - size.width) / 2, yPos, size.width, size.height);
            yPos += size.height;
        }
    }

    private void doNorthWestLayout(int width, int height) {
        int yPos = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(0, yPos, size.width, size.height);
            yPos += size.height;
        }
    }
}

